/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.core.collectors.system.info;

import com.google.common.collect.Lists;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

/**
 * An information group for all the java system properties
 *
 * @author Noam Tenne
 */
public class JavaSysPropInfo extends BasePropInfoGroup {

    private SystemPropInfoGroup systemPropInfoGroup;

    private RuntimeMXBean runtimeMXBean;

    public JavaSysPropInfo() {
        systemPropInfoGroup = new SystemPropInfoGroup("java.class.version",
                "java.home",
                "java.io.tmpdir",
                "java.runtime.name",
                "java.runtime.version",
                "java.specification.name",
                "java.specification.vendor",
                "java.specification.version",
                "java.vendor",
                "java.vendor.url",
                "java.vendor.url.bug",
                "java.version",
                "java.vm.info",
                "java.vm.name",
                "java.vm.specification.name",
                "java.vm.specification.vendor",
                "java.vm.specification.version",
                "java.vm.vendor",
                "java.vm.version",
                "sun.arch.data.model",
                "sun.boot.library.path",
                "sun.cpu.endian",
                "sun.cpu.isalist",
                "sun.io.unicode.encoding",
                "sun.java.launcher",
                "sun.jnu.encoding",
                "sun.management.compiler",
                "sun.os.patch.level");
        runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    }

    @Override
    public InfoObject[] getInfo(boolean isSupportBundles) {
        List<InfoObject> infoObjects = Lists.newArrayList(systemPropInfoGroup.getInfo(isSupportBundles));

        List<String> inputArguments = runtimeMXBean.getInputArguments();

        boolean addedFirstValue = false;
        String key = "JVM Input arguments";
        for (String inputArgument : inputArguments) {
            infoObjects.add(new InfoObject(key, inputArgument));
            if (!addedFirstValue && !isSupportBundles) {
                addedFirstValue = true;
                key = "";
            }
        }

        return infoObjects.toArray(new InfoObject[infoObjects.size()]);
    }

    @Override
    protected String getGroupName() {
        return "Java System Info";
    }
}