/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common;

/**
 * @author Michael Pasternak
 */
public class CollectConfiguration implements Configuration {

    // we enable all collectors by default (see in #RTFACT-8106)
    private boolean enabled = true;

    /**
     * serialization .ctr
     */
    public CollectConfiguration() {
    }

    public CollectConfiguration(boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * @return whether given configuration is enabled
     */
    public boolean isEnabled() {
        return enabled;
    }

    /**
     * @return {@link CollectConfiguration}
     */
    @Override
    public CollectConfiguration get() {
        return this;
    }
}
