/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors.system.info;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.jfrog.support.common.config.SystemInfoConfiguration;
import org.jfrog.support.common.core.AbstractGenericContentCollector;
import org.jfrog.support.common.core.collectors.system.info.CommonInfoWriter;
import org.jfrog.support.common.core.exceptions.BundleConfigurationException;
import org.jfrog.support.common.utils.StringBuilderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoCollector
extends AbstractGenericContentCollector<SystemInfoConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoCollector.class);
    private static final ObjectWriter instance = SystemInfoCollector.initObjectMapper();

    public SystemInfoCollector() {
        super("system");
    }

    private static ObjectWriter initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED).enable(SerializationFeature.INDENT_OUTPUT).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new ParameterNamesModule());
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        return objectMapper.writer((PrettyPrinter)prettyPrinter);
    }

    @Override
    protected StringBuilderWrapper doProduceContent(SystemInfoConfiguration configuration) throws InstantiationException, IllegalAccessException, IOException {
        Map<String, Multimap<String, String>> info = this.createInfoWriter().getInfoMap();
        if (!info.isEmpty()) {
            this.addProductCustomData(info);
            Map<String, Map> toJson = info.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Multimap)entry.getValue()).asMap()));
            return new StringBuilderWrapper(instance.writeValueAsString(toJson));
        }
        this.getLog().debug("No content was fetched from CommonInfoWriter");
        return this.failure();
    }

    protected void addProductCustomData(Map<String, Multimap<String, String>> info) {
    }

    private CommonInfoWriter createInfoWriter() {
        return new CommonInfoWriter();
    }

    @Override
    public Logger getLog() {
        return log;
    }

    @Override
    protected void doEnsureConfiguration(SystemInfoConfiguration configuration) throws BundleConfigurationException {
    }

    @Override
    protected String getFileName() {
        return "system-info.json";
    }
}

