/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumper {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumper.class);
    private static final String JAVA6_FIND_DEADLOCKS_METHOD_NAME = "findDeadlockedThreads";
    private static final String JAVA5_FIND_DEADLOCKS_METHOD_NAME = "findMonitorDeadlockedThreads";
    private static String TAB = "    ";
    private ThreadMXBean tmbean;
    private boolean canDumpSyncLocks = true;
    private boolean ready;

    public ThreadDumper() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.tmbean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
            ObjectName oname = new ObjectName("java.lang:type=Threading");
            MBeanOperationInfo[] mopis = server.getMBeanInfo(oname).getOperations();
            boolean found = false;
            for (MBeanOperationInfo op : mopis) {
                if (!op.getName().equals(JAVA6_FIND_DEADLOCKS_METHOD_NAME)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.canDumpSyncLocks = false;
            }
        }
        catch (Exception e) {
            log.error("Could not initialize the debugging thread dumper.", (Throwable)e);
            return;
        }
        this.ready = true;
    }

    public CharSequence dumpThreads() {
        this.assertReady();
        StringBuilder dump = new StringBuilder();
        if (this.canDumpSyncLocks && this.tmbean.isObjectMonitorUsageSupported() && this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] tinfos;
            dump.append("Full Java thread dump with locks info").append('\n');
            for (ThreadInfo ti : tinfos = this.tmbean.dumpAllThreads(true, true)) {
                this.printThreadInfo(ti, dump);
                LockInfo[] syncs = ti.getLockedSynchronizers();
                this.printLockInfo(syncs, dump);
            }
        } else {
            ThreadInfo[] tinfos;
            dump.append("Full Java thread dump").append('\n');
            long[] tids = this.tmbean.getAllThreadIds();
            for (ThreadInfo ti : tinfos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
                this.printThreadInfo(ti, dump);
            }
        }
        dump.append('\n');
        return dump;
    }

    public boolean findDeadlock(StringBuilder dump) {
        this.assertReady();
        if (this.canDumpSyncLocks && this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findDeadlockedThreads();
            if (tids == null) {
                return false;
            }
            dump.append("Deadlock found:-").append('\n');
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, true, true)) {
                this.printThreadInfo(ti, dump);
                this.printLockInfo(ti.getLockedSynchronizers(), dump);
                dump.append("");
            }
        } else {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findMonitorDeadlockedThreads();
            if (tids == null) {
                return false;
            }
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
                this.printThreadInfo(ti, dump);
                this.printMonitorInfo(ti.getLockedMonitors(), dump);
            }
        }
        return true;
    }

    private void printThreadInfo(ThreadInfo ti, StringBuilder dump) {
        this.printThread(ti, dump);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            dump.append(TAB).append("at ").append(ste.toString()).append('\n');
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                dump.append(TAB).append("  - locked ").append(mi).append('\n');
            }
        }
        dump.append("");
    }

    private void printThread(ThreadInfo ti, StringBuilder dump) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on lock=").append(ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        dump.append((CharSequence)sb).append('\n');
        if (ti.getLockOwnerName() != null) {
            dump.append(TAB).append(" owned by ").append(ti.getLockOwnerName()).append(" Id=").append(ti.getLockOwnerId()).append('\n');
        }
    }

    private void printLockInfo(LockInfo[] locks, StringBuilder dump) {
        dump.append(TAB).append("Locked synchronizers: count = ").append(locks.length).append('\n');
        for (LockInfo li : locks) {
            dump.append(TAB).append("  - ").append(li).append('\n');
        }
        dump.append('\n');
    }

    private void printMonitorInfo(MonitorInfo[] monitors, StringBuilder dump) {
        dump.append(TAB).append("Locked monitors: count = ").append(monitors.length).append('\n');
        for (MonitorInfo mi : monitors) {
            dump.append(TAB).append("  - ").append(mi).append(" locked at ").append('\n');
            dump.append(TAB).append("      ").append(mi.getLockedStackDepth()).append(" ").append(mi.getLockedStackFrame()).append('\n');
        }
    }

    private void assertReady() {
        if (!this.ready) {
            throw new IllegalStateException("Thread dumper was not initialize properly.");
        }
    }
}

