/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.config;

import org.jfrog.support.common.CollectConfiguration;

/**
 * Thread dump collection configuration
 *
 * @author Michael Pasternak
 */
public class ThreadDumpConfiguration extends CollectConfiguration {

    private int count;
    private long interval;

    /**
     * Default .ctr
     */
    public ThreadDumpConfiguration() {
        // we enable all collectors by default (see in #RTFACT-8106)
        setDefaultConfig();
    }

    /**
     * @param enabled is collection enabled
     */
    public ThreadDumpConfiguration(boolean enabled) {
        super(enabled);
        setDefaultConfig();
    }

    /**
     * @param enabled is collection enabled
     * @param count amount of dumps to take
     * @param interval interval between dumps (millis)
     */
    public ThreadDumpConfiguration(boolean enabled, int count, long interval) {
        super(enabled);
        this.count = count;
        this.interval = interval;
    }

    /**
     * @return dumps count
     */
    public int getCount() {
        return count;
    }

    /**
     * @return interval between dumps (millis)
     */
    public long getInterval() {
        return interval;
    }

    /**
     * Sets default configuration on user config absence
     */
    private void setDefaultConfig() {
        count=1;
        interval=0;
    }
}
