/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common;

import java.io.File;

/**
 * Provides org.jfrog.support.common.ContentCollector services
 *
 * @param <T> configuration type declaration
 *
 * @author Michael Pasternak
 */
public interface ContentCollector<T extends CollectConfiguration> {
    /**
     * Collects content according to {@link CollectConfiguration}
     *
     * @param configuration instance specific {@link CollectConfiguration}
     * @param tmpDir output dir
     *
     * @return boolean
     */
    boolean collect(T configuration, File tmpDir);
}
