/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.opentracing;

import java.util.Collections;
import java.util.Map;
import org.jfrog.common.opentracing.TraceHeaderInjector;
import org.jfrog.common.opentracing.TraceIdExtractor;

public class TraceHeaderInjectorImpl
implements TraceHeaderInjector {
    public static final String UBER_TRACE_ID = "uber-trace-id";
    private final TraceIdExtractor traceIdExtractor;

    public TraceHeaderInjectorImpl(TraceIdExtractor traceIdExtractor) {
        this.traceIdExtractor = traceIdExtractor;
    }

    @Override
    public Map<String, String> headersToInject(String httpMethod, String httpURL) {
        String extractedTraceId = this.traceIdExtractor.getTraceId();
        if (extractedTraceId == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(UBER_TRACE_ID, extractedTraceId);
    }

    @Override
    public String getCurrentTraceId() {
        return this.traceIdExtractor.getTraceId();
    }

    @Override
    public void cleanup() {
    }
}

