/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.concurrency;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.jfrog.common.concurrency.ConflictGuard;
import org.jfrog.common.concurrency.ConflictsGuard;
import org.jfrog.common.concurrency.JVMLockWrapper;
import org.jfrog.common.concurrency.JvmConflictGuard;
import org.jfrog.common.concurrency.LockWrapper;
import org.jfrog.common.concurrency.MonitoringReentrantLock;

public class JvmConflictsGuard<K>
implements ConflictsGuard<K> {
    private LoadingCache<K, LockWrapper> locks;

    public JvmConflictsGuard(long timeout) {
        this.locks = CacheBuilder.newBuilder().initialCapacity(2000).softValues().expireAfterAccess(timeout, TimeUnit.MINUTES).build(new CacheLoader<K, LockWrapper>(){

            public LockWrapper load(@Nonnull K key) {
                return new JVMLockWrapper(new MonitoringReentrantLock());
            }
        });
    }

    @Override
    public void unlock(K key) {
        try {
            this.getLockInternal(key).unlock();
        }
        catch (IllegalMonitorStateException e) {
            throw new RuntimeException("Failed to release lock for key: " + key, e);
        }
    }

    @Override
    public void forceUnlock(K key) {
        this.unlock(key);
    }

    private LockWrapper getLockInternal(K key) {
        try {
            return (LockWrapper)this.locks.get(key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve lock on key: " + key, e);
        }
    }

    @Override
    public boolean tryToLock(K key, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        return this.getLockInternal(key).tryLock(timeout, timeoutUnit);
    }

    @Override
    public int size() {
        int count = 0;
        for (LockWrapper lockWrapper : this.locks.asMap().values()) {
            if (!lockWrapper.isLocked()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLocked(K key) {
        return this.getLockInternal(key).isLocked();
    }

    @Override
    public Set<K> keySet() {
        return Sets.newHashSet();
    }

    @Override
    public ConflictGuard getLock(K key) {
        return new JvmConflictGuard(this.getLockInternal(key));
    }
}

