/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.jfrog.common.ArgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigArgUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigArgUtils.class);

    private ConfigArgUtils() {
    }

    public static Long requirePositive(Long value, String fieldName) {
        if (value == null) {
            return null;
        }
        return ArgUtils.requirePositive(value, ConfigArgUtils.getMessage(fieldName, value));
    }

    public static Integer requirePositive(Integer value, String fieldName) {
        if (value == null) {
            return null;
        }
        return ArgUtils.requirePositive(value, ConfigArgUtils.getMessage(fieldName, value));
    }

    public static List<String> requireLegalPatterns(List<String> value, String fieldName) {
        if (Objects.isNull(value) || value.isEmpty()) {
            return value;
        }
        return ArgUtils.requireSatisfies(value, patterns -> {
            try {
                patterns.forEach(Pattern::compile);
                return true;
            }
            catch (PatternSyntaxException e) {
                log.debug("failed to compile regex. ", (Throwable)e);
                return false;
            }
        }, fieldName + " contains an illegal regular expression");
    }

    private static String getMessage(String fieldName, Number value) {
        return "'" + fieldName + "' must be a positive number. Got " + value;
    }

    public static Integer getSystemPropertyOrValue(String systemProp, Integer defaultValue) {
        return ConfigArgUtils.getSystemPropertyOrValue(systemProp, Integer::valueOf, defaultValue);
    }

    public static Long getSystemPropertyOrValue(String systemProp, Long defaultValue) {
        return ConfigArgUtils.getSystemPropertyOrValue(systemProp, Long::valueOf, defaultValue);
    }

    public static Boolean getSystemPropertyOrValue(String systemProp, Boolean defaultValue) {
        return ConfigArgUtils.getSystemPropertyOrValue(systemProp, Boolean::valueOf, defaultValue);
    }

    public static String getSystemPropertyOrValue(String systemProp, String defaultValue) {
        return ConfigArgUtils.getSystemPropertyOrValue(systemProp, Function.identity(), defaultValue);
    }

    private static <T> T getSystemPropertyOrValue(String sysProp, Function<String, T> valueOf, T defaultValue) {
        if (System.getProperties().containsKey(sysProp)) {
            try {
                return valueOf.apply(System.getProperty(sysProp));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Integer requireNonNegative(Integer value, String fieldName) {
        if (value == null) {
            return null;
        }
        return ArgUtils.requireNonNegative(value, ConfigArgUtils.getMessage(fieldName, value));
    }

    public static Float requirePositive(Float value, String fieldName) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(ArgUtils.requirePositive(value, ConfigArgUtils.getMessage(fieldName, value)));
    }

    public static <T> T requireSatisfies(Predicate<T> predicate, T value, String message) {
        if (value == null) {
            return null;
        }
        return ArgUtils.requireSatisfies(value, predicate, message);
    }

    public static <T, R extends T> List<R> requireType(@Nonnull List<? extends T> entities, Class<R> clazz, String fieldName) {
        return ConfigArgUtils.requireType(entities, clazz, List.class, fieldName);
    }

    public static <T, R extends T> Set<R> requireType(@Nonnull Set<? extends T> entities, Class<R> clazz, String fieldName) {
        return ConfigArgUtils.requireType(entities, clazz, Set.class, fieldName);
    }

    private static <T, R extends T, C extends Collection<? extends T>, RC extends Collection<R>> RC requireType(C entities, Class<R> clazz, Class<RC> collectionClazz, String fieldName) {
        if (entities.stream().anyMatch(e -> !clazz.isInstance(e))) {
            throw new IllegalStateException("All " + fieldName + " entities must be of instance " + clazz.getName());
        }
        return (RC)((Collection)collectionClazz.cast(entities));
    }
}

