/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jfrog.common.archive.ArchiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchiveUtils {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUtils.class);

    private ArchiveUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archive(File sourceDirectory, File destinationArchive, boolean recurse, ArchiveType archiveType) throws IOException {
        if (sourceDirectory == null || destinationArchive == null) {
            throw new IllegalArgumentException("Supplied destinations cannot be null.");
        }
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Supplied source directory must be an existing directory.");
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        String archivePath = destinationArchive.getAbsolutePath();
        log.debug("Beginning to archive '{}' into '{}'", (Object)sourcePath, (Object)archivePath);
        FileOutputStream destinationOutputStream = new FileOutputStream(destinationArchive);
        ArchiveOutputStream archiveOutputStream = ArchiveUtils.createArchiveOutputStream(new BufferedOutputStream(destinationOutputStream), archiveType);
        try {
            Collection childrenFiles = FileUtils.listFiles((File)sourceDirectory, null, (boolean)recurse);
            childrenFiles.remove(destinationArchive);
            for (File childFile : childrenFiles) {
                String childPath = childFile.getAbsolutePath();
                String relativePath = childPath.substring(sourcePath.length() + 1);
                relativePath = FilenameUtils.separatorsToUnix((String)relativePath);
                ArchiveEntry archiveEntry = ArchiveUtils.createArchiveEntry(childFile, relativePath, archiveType);
                archiveOutputStream.putArchiveEntry(archiveEntry);
                try (FileInputStream fileInputStream = new FileInputStream(childFile);){
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)archiveOutputStream);
                }
                finally {
                    archiveOutputStream.closeArchiveEntry();
                }
                log.debug("Archive '{}' into '{}'", (Object)childPath, (Object)archivePath);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)archiveOutputStream);
        }
        log.debug("Completed archiving of '{}' into '{}'", (Object)sourcePath, (Object)archivePath);
    }

    public static ArchiveOutputStream createArchiveOutputStream(OutputStream outputStream, ArchiveType archiveType) throws IOException {
        ZipArchiveOutputStream result;
        switch (archiveType) {
            case ZIP: {
                result = new ZipArchiveOutputStream(outputStream);
                break;
            }
            case TAR: {
                result = new TarArchiveOutputStream(outputStream);
                ((TarArchiveOutputStream)result).setLongFileMode(2);
                break;
            }
            case TARGZ: 
            case TGZ: {
                result = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(outputStream));
                ((TarArchiveOutputStream)result).setLongFileMode(2);
                break;
            }
            default: {
                throw ArchiveUtils.unsupportedArchiveType(archiveType);
            }
        }
        return result;
    }

    public static ArchiveEntry createArchiveEntry(String relativePath, ArchiveType archiveType, long size) {
        switch (archiveType) {
            case ZIP: {
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(relativePath);
                zipEntry.setSize(size);
                return zipEntry;
            }
            case TAR: 
            case TARGZ: 
            case TGZ: {
                TarArchiveEntry tarEntry = new TarArchiveEntry(relativePath);
                tarEntry.setSize(size);
                return tarEntry;
            }
        }
        throw ArchiveUtils.unsupportedArchiveType(archiveType);
    }

    private static ArchiveEntry createArchiveEntry(File file, String relativePath, ArchiveType archiveType) {
        switch (archiveType) {
            case ZIP: {
                return new ZipArchiveEntry(file, relativePath);
            }
            case TAR: {
                return new TarArchiveEntry(file, relativePath);
            }
            case TARGZ: {
                return new TarArchiveEntry(file, relativePath);
            }
            case TGZ: {
                return new TarArchiveEntry(file, relativePath);
            }
        }
        throw ArchiveUtils.unsupportedArchiveType(archiveType);
    }

    private static IllegalArgumentException unsupportedArchiveType(ArchiveType archiveType) {
        return new IllegalArgumentException("Unsupported archive type: '" + archiveType + "'");
    }
}

