/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.archive;

public enum ArchiveType {
    ZIP("zip"),
    TAR("tar"),
    TARGZ("tar.gz"),
    TGZ("tgz"),
    TARBZ2("tar.bz2");

    private final String value;

    private ArchiveType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static ArchiveType fromValue(String v) {
        for (ArchiveType c : ArchiveType.values()) {
            if (!c.value.equalsIgnoreCase(v)) continue;
            return c;
        }
        throw new IllegalArgumentException("Archive type parameter must be one of: 'zip','tar','tar.gz','tgz'. You sent: " + v);
    }
}

