/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.jfrog.common.StreamSupportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=Deserializer.class)
public abstract class JsonParserFastStream {
    private static final Logger log = LoggerFactory.getLogger(JsonParserFastStream.class);
    private final JsonParser jp;
    ArrayList<AbstractMap.SimpleEntry<String, Object>> fields = new ArrayList();

    private JsonParserFastStream(JsonParser jp) {
        this.jp = jp;
    }

    public static JsonParserFastStream parse(Reader reader) throws IOException {
        return Helper.parse((Reader)reader).obj;
    }

    public abstract Stream<JsonNode> getArray(String var1, Consumer<Exception> var2) throws IOException;

    public abstract Stream<JsonNode> getArray(Consumer<Exception> var1) throws IOException;

    public abstract Stream<Map.Entry<String, JsonNode>> getFields(Consumer<Exception> var1) throws IOException;

    Stream<JsonNode> parseArray(String name, Consumer<Exception> onFinish) throws IOException {
        Consumer<JsonParserFastStream> consumeFields = x -> {
            while (this.jp.hasCurrentToken() && this.jp.getCurrentToken().equals((Object)JsonToken.FIELD_NAME)) {
                try {
                    String currentName = this.jp.getCurrentName();
                    if (currentName.equals(name)) break;
                    this.jp.nextToken();
                    Object val = null;
                    if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_STRING)) {
                        val = this.jp.getText();
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_NUMBER_INT)) {
                        val = this.jp.getIntValue();
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_NUMBER_FLOAT)) {
                        val = Float.valueOf(this.jp.getFloatValue());
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                        val = this.jp.readValueAsTree();
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_NULL)) {
                        val = null;
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_TRUE)) {
                        val = true;
                    } else if (this.jp.getCurrentToken().equals((Object)JsonToken.VALUE_FALSE)) {
                        val = false;
                    }
                    this.fields.add(new AbstractMap.SimpleEntry<String, String>(currentName, (String)val));
                    this.jp.nextToken();
                }
                catch (IOException e) {
                    onFinish.accept(e);
                    break;
                }
            }
        };
        Consumer<JsonParserFastStream> arrayEnded = x -> {
            consumeFields.accept(null);
            if (this.jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT)) {
                onFinish.accept(null);
                return;
            }
            log.trace("Done");
        };
        Function<JsonParserFastStream, Stream> readObject = x -> {
            try {
                this.jp.nextToken();
                consumeFields.accept(null);
                if (this.jp.getCurrentToken().equals((Object)JsonToken.FIELD_NAME)) {
                    this.jp.nextToken();
                    if (this.jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY)) {
                        return this.parseArray(arrayEnded, onFinish);
                    }
                    String msg = "parse array required";
                    log.trace(msg);
                    onFinish.accept(new RuntimeException(msg));
                    return null;
                }
            }
            catch (JsonParseException e) {
                log.trace("parse ", (Throwable)e);
                onFinish.accept((Exception)((Object)e));
                return null;
            }
            catch (IOException e) {
                String msg = "Failed parseFields";
                if (log.isDebugEnabled()) {
                    log.debug(msg + ", fields read: {}", (Object)this.fields.toString());
                }
                onFinish.accept(e);
                return null;
            }
            onFinish.accept(new RuntimeException("unknown"));
            return null;
        };
        return readObject.apply(null);
    }

    Stream<JsonNode> parseArray(Consumer<Exception> onFinish) throws IOException {
        return this.parseArray((JsonParserFastStream x) -> {}, onFinish);
    }

    Stream<JsonNode> parseArray(Consumer<JsonParserFastStream> afterResults, Consumer<Exception> onFinish) throws IOException {
        Function<Integer, JsonNode> generate = it -> {
            try {
                this.jp.nextToken();
                if (this.jp.getCurrentToken().equals((Object)JsonToken.END_ARRAY)) {
                    this.jp.nextToken();
                    afterResults.accept(null);
                    return null;
                }
                return (JsonNode)this.jp.readValueAsTree();
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed parseFields, fields read: {}", (Object)this.fields.toString(), (Object)ex);
                }
                onFinish.accept(ex);
                return null;
            }
        };
        return (Stream)StreamSupportUtils.generateTillNull(generate).onClose(() -> onFinish.accept(null));
    }

    Stream<Map.Entry<String, JsonNode>> parseFields(Consumer<Exception> onFinish) throws IOException {
        Function<JsonParserFastStream, Stream> readResults = x -> {
            try {
                this.jp.nextToken();
                if (this.jp.getCurrentToken().equals((Object)JsonToken.FIELD_NAME)) {
                    Function<Integer, Map.Entry> generate = it -> {
                        try {
                            if (this.jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT)) {
                                this.jp.nextToken();
                                onFinish.accept(null);
                                return null;
                            }
                            String currentName = this.jp.getCurrentName();
                            this.jp.nextToken();
                            AbstractMap.SimpleEntry<String, TreeNode> res = new AbstractMap.SimpleEntry<String, TreeNode>(currentName, this.jp.readValueAsTree());
                            this.jp.nextToken();
                            return res;
                        }
                        catch (IOException ex) {
                            if (log.isDebugEnabled()) {
                                log.debug("Failed parseFields, fields read: {}", (Object)this.fields.toString(), (Object)ex);
                            }
                            onFinish.accept(ex);
                            return null;
                        }
                    };
                    return (Stream)StreamSupportUtils.generateTillNull(generate).onClose(() -> onFinish.accept(null));
                }
                String msg = "Failed parseFields, not a field name";
                if (log.isDebugEnabled()) {
                    log.debug(msg + ", fields read: {}", (Object)this.fields.toString());
                }
                onFinish.accept(new RuntimeException(msg));
                return null;
            }
            catch (IOException e) {
                String msg = "Failed parseFields";
                if (log.isDebugEnabled()) {
                    log.debug(msg + ", fields read: {}", (Object)this.fields.toString());
                }
                onFinish.accept(e);
                return null;
            }
        };
        Stream result = readResults.apply(null);
        if (result == null) {
            return Stream.empty();
        }
        return result;
    }

    public static class Helper {
        final JsonParserFastStream obj;
        final JsonContext context;

        Helper(JsonContext context, JsonParserFastStream obj) {
            this.context = context;
            this.obj = obj;
        }

        static Helper parse(Reader reader) throws IOException {
            JsonContext context = new JsonContext();
            return Helper.parse(context, reader);
        }

        private static Helper parse(JsonContext context, Reader reader) throws IOException {
            return new Helper(context, context.parse(reader));
        }

        public <T> Stream<T> getArray(String name, TypeReference<T> valueTypeRef, Consumer<Exception> onFinish) throws IOException {
            Stream<JsonNode> jsonNodeStream = this.obj.getArray(name, onFinish);
            return (Stream)this.mapTo(jsonNodeStream, valueTypeRef, onFinish).onClose(jsonNodeStream::close);
        }

        public <T> Stream<T> getArray(TypeReference<T> valueTypeRef, Consumer<Exception> onFinish) throws IOException {
            Stream<JsonNode> jsonNodeStream = this.obj.getArray(onFinish);
            return (Stream)this.mapTo(jsonNodeStream, valueTypeRef, onFinish).onClose(jsonNodeStream::close);
        }

        private <T> Stream<T> mapTo(Stream<JsonNode> jsonNodeStream, TypeReference<T> valueTypeRef, Consumer<Exception> onFinish) {
            Class cls = this.context.getClassFromTypeRef(valueTypeRef);
            return jsonNodeStream.map(it -> {
                try {
                    return this.context.mapper.treeToValue((TreeNode)it, cls);
                }
                catch (IOException e) {
                    onFinish.accept(e);
                    return null;
                }
            }).filter(Objects::nonNull);
        }
    }

    public static class JsonContext {
        public final ObjectMapper mapper = new ObjectMapper();
        public final JsonFactory factory = new JsonFactory((ObjectCodec)this.mapper);

        public JsonParserFastStream parse(Reader reader) throws IOException {
            return (JsonParserFastStream)this.factory.createParser(reader).readValueAs(JsonParserFastStream.class);
        }

        public <T> T toValue(JsonNode node, TypeReference<T> valueTypeRef) throws IOException {
            Class<T> cls = this.getClassFromTypeRef(valueTypeRef);
            return (T)this.mapper.treeToValue((TreeNode)node, cls);
        }

        public <T> JsonNode toJsonNode(T value) {
            return this.mapper.valueToTree(value);
        }

        private <T> Class<T> getClassFromTypeRef(TypeReference<T> valueTypeRef) {
            JavaType type = this.mapper.getTypeFactory().constructType(valueTypeRef);
            return type.getRawClass();
        }
    }

    static class Deserializer
    extends JsonDeserializer<JsonParserFastStream> {
        Deserializer() {
        }

        public JsonParserFastStream deserialize(final JsonParser jp, DeserializationContext ctxt) throws IOException {
            return new JsonParserFastStream(jp){

                @Override
                public Stream<JsonNode> getArray(String name, Consumer<Exception> onFinish) throws IOException {
                    return (Stream)this.parseArray(name, onFinish).onClose(() -> IOUtils.closeQuietly((Closeable)jp));
                }

                @Override
                public Stream<JsonNode> getArray(Consumer<Exception> onFinish) throws IOException {
                    return (Stream)this.parseArray(onFinish).onClose(() -> IOUtils.closeQuietly((Closeable)jp));
                }

                @Override
                public Stream<Map.Entry<String, JsonNode>> getFields(Consumer<Exception> onFinish) throws IOException {
                    return (Stream)this.parseFields(onFinish).onClose(() -> IOUtils.closeQuietly((Closeable)jp));
                }
            };
        }
    }
}

