package org.jfrog.common;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

/**
 * @author maximy & Uriah Levy <3
 */
public interface LazyCache<K, V> {

    Optional<V> value(K key);

    V valueFromCache(K lookup);

    Map<K, Optional<V>> getValues(Collection<K> keys);

    void put(K key, V value);

    void putAll(Map<K, V> entries);

    void limitCachingToCurrentThread();

    void invalidateAll();

    boolean invalidate(K k);

    void invalidate(Collection<K> k);

    LazyCache<K, V> prefetch();

    Map<K, V> asMap();

    void removeCachingLimit(Class clazz);
}