/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jfrog.client.util.KeyStoreProvider;
import org.jfrog.client.util.KeyStoreProviderException;

class SimpleKeyStoreProvider
implements KeyStoreProvider {
    private KeyStore keyStore;
    private String password;

    SimpleKeyStoreProvider(KeyStore keyStore, String keyStorePassword) throws KeyStoreProviderException {
        if (StringUtils.isBlank((String)keyStorePassword)) {
            throw new KeyStoreProviderException("Password cannot be empty");
        }
        if (keyStore == null) {
            throw new KeyStoreProviderException("KeyStore is missing");
        }
        this.keyStore = keyStore;
        this.password = keyStorePassword;
    }

    @Override
    public KeyStore provide() throws KeyStoreException {
        return Objects.requireNonNull(this.keyStore);
    }

    @Override
    public char[] getPassword() {
        return this.password.toCharArray();
    }
}

