/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jfrog.client.util.KeyStoreProvider;
import org.jfrog.client.util.KeyStoreProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileKeyStoreProvider
implements KeyStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(FileKeyStoreProvider.class);
    private KeyStore keyStore;
    private String keyStorePassword;

    FileKeyStoreProvider(String keyStoreLocation, String keyStorePassword) throws KeyStoreProviderException {
        if (StringUtils.isBlank((String)keyStoreLocation)) {
            throw new KeyStoreProviderException("No KeyStore file was provided.");
        }
        if (StringUtils.isBlank((String)keyStorePassword)) {
            throw new KeyStoreProviderException("Password cannot be empty");
        }
        File keyStoreFile = new File(keyStoreLocation);
        if (!keyStoreFile.exists()) {
            log.error("Unable to find KeyStore at: '{}'", (Object)keyStoreFile.getAbsolutePath());
            throw new KeyStoreProviderException("Unable to find KeyStore at: " + keyStoreFile.getAbsolutePath());
        }
        this.keyStorePassword = keyStorePassword;
        try (FileInputStream clientCertKeyStore = new FileInputStream(keyStoreFile);){
            KeyStore jks = KeyStore.getInstance("JKS");
            jks.load(clientCertKeyStore, keyStorePassword.toCharArray());
            this.keyStore = jks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Unable to load certificate: {}", (Object)e.getMessage());
            log.debug("Unable to load certificate: {}", (Throwable)e);
            throw new KeyStoreProviderException("Unable to load certificate.", e);
        }
    }

    @Override
    public KeyStore provide() throws KeyStoreException {
        return Objects.requireNonNull(this.keyStore);
    }

    @Override
    public char[] getPassword() {
        return this.keyStorePassword.toCharArray();
    }
}

