/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import javax.annotation.Nullable;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;
import org.jfrog.client.util.NoProxyHostsEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHostSpecificProxyRoutePlanner
extends DefaultRoutePlanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultHostSpecificProxyRoutePlanner.class);
    private final HttpHost defaultHost;
    private final HttpHost proxyHost;
    private final NoProxyHostsEvaluator noProxyHostsEvaluator;

    private DefaultHostSpecificProxyRoutePlanner(@Nullable HttpHost defaultHost, @Nullable HttpHost proxyHost, @Nullable String noProxyHosts) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.defaultHost = defaultHost;
        this.proxyHost = proxyHost;
        this.noProxyHostsEvaluator = new NoProxyHostsEvaluator(noProxyHosts);
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        if (host == null) {
            host = this.defaultHost;
        }
        return super.determineRoute(host, request, context);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) {
        if (this.proxyHost != null && (this.isTargetLocalhost(target) || this.noProxyHostsEvaluator.shouldBypassProxy(target.toHostString()))) {
            return null;
        }
        return this.proxyHost;
    }

    public HttpHost getDefaultHost() {
        return this.defaultHost;
    }

    public HttpHost getProxy() {
        return this.proxyHost;
    }

    public String getNoProxyHosts() {
        return this.noProxyHostsEvaluator.getNoProxyHosts();
    }

    private boolean isTargetLocalhost(HttpHost target) {
        return target.getHostName().equalsIgnoreCase("localhost") || target.getHostName().equalsIgnoreCase("127.0.0.1");
    }

    public static class Builder {
        private HttpHost defaultHost;
        private HttpHost proxyHost;
        private String noProxyHosts;

        public Builder defaultHost(HttpHost defaultHost) {
            this.defaultHost = defaultHost;
            return this;
        }

        public Builder proxyHost(HttpHost proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder noProxyHosts(String noProxyHosts) {
            this.noProxyHosts = noProxyHosts;
            return this;
        }

        public DefaultHostSpecificProxyRoutePlanner build() {
            return new DefaultHostSpecificProxyRoutePlanner(this.defaultHost, this.proxyHost, this.noProxyHosts);
        }
    }
}

