package org.jfrog.client.http;

import org.apache.commons.io.IOUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

/**
 * @author Yinon Avraham.
 */
public class RestResponseImpl implements RestResponse {

    private final int statusCode;
    private final byte[] body;
    private final Charset charset;

    public RestResponseImpl(int statusCode, byte[] body, Charset charset) {
        this.statusCode = statusCode;
        this.body = body == null ? null : Arrays.copyOf(body, body.length);
        this.charset = charset;
    }

    @Override
    public int getStatusCode() {
        return statusCode;
    }

    @Override
    public boolean isSuccessful() {
        return statusCode >= 200 && statusCode < 300;
    }

    @Override
    public String getBodyAsString() {
        try {
            return body == null ? null : IOUtils.toString(new ByteArrayInputStream(body), charset);
        } catch (IOException e) {
            throw new RuntimeException("Failed to create body as string from bytes (charset=" + charset + ")", e);
        }
    }

    @Override
    public byte[] getBody() {
        return body;
    }
}
