package org.jfrog.client.util;

import org.apache.commons.lang.StringUtils;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Objects;

/**
 * @author Shay Bagants
 */
class SimpleKeyStoreProvider implements KeyStoreProvider {

    private KeyStore keyStore;
    private String password;

    SimpleKeyStoreProvider(KeyStore keyStore, String keyStorePassword) throws KeyStoreProviderException {
        if (StringUtils.isBlank(keyStorePassword)) {
            throw new KeyStoreProviderException("Password cannot be empty");
        }
        if (keyStore == null) {
            throw new KeyStoreProviderException("KeyStore is missing");
        }
        this.keyStore = keyStore;
        this.password = keyStorePassword;
    }

    @Override
    public KeyStore provide() throws KeyStoreException {
        return Objects.requireNonNull(keyStore);
    }

    @Override
    public char[] getPassword() {
        return password.toCharArray();
    }
}
