package org.jfrog.client.http;

import javax.annotation.Nullable;

/**
 * @author Yinon Avraham.
 */
public interface RestResponse {

    /**
     * Get the status code of the response
     */
    int getStatusCode();

    /**
     * Get whether the request was executed successfully.
     * This is a helper method that simply checks that the response status code is in the range [200..300).
     * @see #getStatusCode()
     */
    boolean isSuccessful();

    /**
     * Get the response body as string.
     * @return the body as String, or <tt>null</tt> if the response did not have any enclosing body.
     * @see #getBody()
     */
    @Nullable
    String getBodyAsString();

    /**
     * Get the bytes of the response body.
     * @return the body as a byte array, or <tt>null</tt> if the response did not have any enclosing body.
     * @see #getBodyAsString()
     */
    @Nullable
    byte[] getBody();
}
