package org.jfrog.client.http;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.params.ConnRoutePNames;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpParamsNames;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;

public class CloseableHttpClientWithParamsDecorator extends CloseableHttpClientDecorator {

    private final HttpParams params;

    public CloseableHttpClientWithParamsDecorator(CloseableHttpClient closeableHttpClient,
            PoolingHttpClientConnectionManager clientConnectionManager, boolean useKerberos, RequestConfig requestConfig) {
        super(closeableHttpClient, clientConnectionManager, useKerberos, requestConfig);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws
            IOException {
        // For every request, if proxy was configured then set default proxy parameter on the request
        Object defaultProxy = getParams().getParameter(ConnRoutePNames.DEFAULT_PROXY);
        if (defaultProxy != null) {
            HttpParams params = request.getParams();
            if (params instanceof HttpParamsNames && !((HttpParamsNames) params).getNames().isEmpty()) {
                if (params.getParameter(ConnRoutePNames.DEFAULT_PROXY) == null) {
                    params.setParameter(ConnRoutePNames.DEFAULT_PROXY, defaultProxy);
                }
            }
        }
        return super.doExecute(target, request, context);
    }

    @Deprecated
    @Override
    public HttpParams getParams() {
        try {
            return super.getParams();
        } catch (UnsupportedOperationException e) {
            return params;
        }
    }
}
