/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jfrog.client.util.KeyStoreProvider;
import org.jfrog.client.util.KeyStoreProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InputStreamKeyStoreProvider
implements KeyStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(InputStreamKeyStoreProvider.class);
    private KeyStore keyStore;
    private char[] keyStorePasswordChar;

    InputStreamKeyStoreProvider(InputStream keyStoreInputStream, String keyStorePassword) throws KeyStoreProviderException {
        if (StringUtils.isBlank((String)keyStorePassword)) {
            throw new KeyStoreProviderException("Password cannot be empty");
        }
        if (keyStoreInputStream == null) {
            throw new KeyStoreProviderException("Stream is missing");
        }
        this.keyStorePasswordChar = keyStorePassword.toCharArray();
        try {
            KeyStore jks = KeyStore.getInstance("JKS");
            jks.load(keyStoreInputStream, this.keyStorePasswordChar);
            this.keyStore = jks;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Unable to load stream into keystore. {}", (Object)e.getMessage());
            log.debug("Unable to load stream into keystore.", (Throwable)e);
            throw new KeyStoreProviderException(e.getMessage(), e);
        }
        finally {
            try {
                if (keyStoreInputStream != null) {
                    keyStoreInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public KeyStore provide() throws KeyStoreException {
        return Objects.requireNonNull(this.keyStore);
    }

    @Override
    public char[] getPassword() {
        return this.keyStorePasswordChar;
    }
}

