/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http.auth;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthProvider {
    private final CloseableHttpClient closeableHttpClient;
    private static final Logger log = LoggerFactory.getLogger(KerberosAuthProvider.class);
    public static final String KRB_LOGIN = "KrbLogin";

    public KerberosAuthProvider(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpResponse executeKerberos(String principal, char[] password, final HttpRequestBase request) {
        LoginContext loginContext = null;
        CloseableHttpResponse response = null;
        try {
            final AppConfigurationEntry[] passwordConfigurationEntry = this.getPasswordConfigurationEntry();
            loginContext = new LoginContext(KRB_LOGIN, new Subject(), new KerberosCallBackHandler(principal, password), new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    if (KerberosAuthProvider.KRB_LOGIN.equals(name)) {
                        return passwordConfigurationEntry;
                    }
                    return null;
                }
            });
            log.trace("Obtaining password subject for principal '{}'", (Object)principal);
            loginContext.login();
            PrivilegedAction sendAction = new PrivilegedAction(){
                CloseableHttpResponse res = null;

                public Object run() {
                    try {
                        log.trace("Executing PrivilegedAction callback");
                        this.res = KerberosAuthProvider.this.closeableHttpClient.execute((HttpUriRequest)request);
                    }
                    catch (IOException e) {
                        log.error("Error during privileged action execution, " + e.getMessage());
                    }
                    return this.res;
                }
            };
            log.trace("Executing PrivilegedAction using password subject principals '{}'", loginContext.getSubject().getPrincipals());
            CloseableHttpResponse closeableHttpResponse = response = (CloseableHttpResponse)Subject.doAs(loginContext.getSubject(), sendAction);
            this.logoutKerberos(loginContext);
            return closeableHttpResponse;
        }
        catch (LoginException le) {
            log.error("Kerberos login has failed, " + le.getMessage());
            log.debug("Cause: {}", (Throwable)le);
        }
        finally {
            this.logoutKerberos(loginContext);
        }
        return null;
    }

    private void logoutKerberos(LoginContext loginCOntext) {
        if (loginCOntext != null) {
            try {
                log.trace("Log out of principals {}", loginCOntext.getSubject().getPrincipals());
                loginCOntext.logout();
            }
            catch (LoginException e) {
                log.debug("Logout has failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpResponse executeKerberos(String userPrincipal, String keyTabLocation, final HttpRequestBase request) {
        LoginContext loginContext = null;
        CloseableHttpResponse response = null;
        try {
            final AppConfigurationEntry[] configurationEntry = this.getKeyTabConfigurationEntry(keyTabLocation, userPrincipal);
            loginContext = new LoginContext(KRB_LOGIN, new Subject(), new KerberosCallBackHandler(userPrincipal), new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    if (KerberosAuthProvider.KRB_LOGIN.equals(name)) {
                        return configurationEntry;
                    }
                    return null;
                }
            });
            log.trace("Obtaining keytab subject for principal '{}'", (Object)userPrincipal);
            loginContext.login();
            PrivilegedAction sendAction = new PrivilegedAction(){
                CloseableHttpResponse res = null;

                public Object run() {
                    try {
                        log.trace("Executing PrivilegedAction callback");
                        this.res = KerberosAuthProvider.this.closeableHttpClient.execute((HttpUriRequest)request);
                    }
                    catch (IOException e) {
                        log.error("Error during privileged action execution, " + e.getMessage());
                    }
                    return this.res;
                }
            };
            log.trace("Executing PrivilegedAction using keytab subject principals '{}'", loginContext.getSubject().getPrincipals());
            CloseableHttpResponse closeableHttpResponse = response = (CloseableHttpResponse)Subject.doAs(loginContext.getSubject(), sendAction);
            this.logoutKerberos(loginContext);
            return closeableHttpResponse;
        }
        catch (LoginException le) {
            log.error("Kerberos login has failed, " + le.getMessage());
        }
        finally {
            this.logoutKerberos(loginContext);
        }
        return null;
    }

    private AppConfigurationEntry[] getKeyTabConfigurationEntry(String keyTabLocation, String userPrincipal) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("keyTab", keyTabLocation);
        options.put("principal", userPrincipal);
        options.put("isInitiator", "true");
        options.put("debug", Boolean.toString(log.isDebugEnabled()));
        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    private AppConfigurationEntry[] getPasswordConfigurationEntry() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useSubjectCredsOnly", "false");
        options.put("doNotPrompt", "false");
        options.put("useTicketCache", "true");
        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    class KerberosCallBackHandler
    implements CallbackHandler {
        private final String principal;
        private final char[] password;

        public KerberosCallBackHandler(String principal, char[] password) {
            this.principal = principal;
            this.password = password;
        }

        public KerberosCallBackHandler(String principal) {
            this.principal = principal;
            this.password = null;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            log.trace("KerberosCallBackHandler is invoked");
            for (Callback callback : callbacks) {
                log.trace("processing callback {}", (Object)callback.getClass().getSimpleName());
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.principal);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unknown Callback");
            }
        }
    }
}

