/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.client.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class RestRequest {
    private final String method;
    private final String path;
    private final byte[] body;
    private final List<Pair<String, String>> queryParams;
    private final List<Pair<String, String>> headers;
    private final Integer socketTimeout;

    private RestRequest(@Nonnull String method, @Nonnull String path, @Nullable byte[] body, @Nonnull List<Pair<String, String>> queryParams, @Nonnull List<Pair<String, String>> headers, Integer socketTimeout) {
        this.method = Objects.requireNonNull(method, "method is required");
        this.path = Objects.requireNonNull(path, "path is required");
        this.body = body == null ? null : Arrays.copyOf(body, body.length);
        this.queryParams = Collections.unmodifiableList(new ArrayList<Pair<String, String>>(queryParams));
        this.headers = Collections.unmodifiableList(new ArrayList<Pair<String, String>>(headers));
        this.socketTimeout = socketTimeout;
    }

    public static Builder request(@Nonnull String method, @Nonnull String path) {
        return new Builder(method, path);
    }

    public static Builder get(@Nonnull String path) {
        return RestRequest.request("GET", path);
    }

    public static Builder post(@Nonnull String path) {
        return RestRequest.request("POST", path);
    }

    public static Builder put(@Nonnull String path) {
        return RestRequest.request("PUT", path);
    }

    public static Builder patch(@Nonnull String path) {
        return RestRequest.request("PATCH", path);
    }

    public static Builder delete(@Nonnull String path) {
        return RestRequest.request("DELETE", path);
    }

    public static Builder head(@Nonnull String path) {
        return RestRequest.request("HEAD", path);
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public byte[] getBody() {
        return this.body;
    }

    @Nonnull
    public List<Pair<String, String>> getQueryParams() {
        return this.queryParams;
    }

    @Nonnull
    public List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public static class Builder {
        private final String method;
        private final String path;
        private byte[] body;
        private final List<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        private final List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        private Integer socketTimeout = 0;

        private Builder(@Nonnull String method, @Nonnull String path) {
            this.method = Objects.requireNonNull(method, "method is required");
            this.path = Objects.requireNonNull(path, "path is required");
        }

        @Nonnull
        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        @Nonnull
        public Builder body(String body, Charset charset) {
            charset = charset == null ? Charset.forName("UTF-8") : charset;
            this.body = body == null ? null : body.getBytes(charset);
            return this;
        }

        @Nonnull
        public Builder queryParam(@Nonnull String key, String value) {
            this.queryParams.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull String name, String value) {
            this.headers.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
            return this;
        }

        @Nonnull
        public Builder contentType(@Nonnull String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Builder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public RestRequest build() {
            return new RestRequest(this.method, this.path, this.body, this.queryParams, this.headers, this.socketTimeout);
        }
    }
}

