package org.jfrog.common.config.diff;

import org.apache.commons.lang3.builder.DiffResult;

/**
 * An interface that all (generated) diff generators must implement.
 * Use this to access the implementations
 *
 * @author Noam Shemesh
 */
public interface DiffFunctions {
    /**
     * Returns whether a class is supported by diffFunctions
     */
    <T> boolean containsClass(Class<T> c);

    /**
     * Returns the difference between two objects
     */
    <T> DiffResult diffFor(Class<T> c, T object, T other);
}
