/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.config.diff;

import com.fasterxml.jackson.annotation.JsonCreator;

public class DataDiff<T> {
    private final String prefixContext;
    private final String fieldName;
    private final T newValue;
    private final T oldValue;

    public DataDiff(String fieldName, T oldValue, T newValue) {
        this("", fieldName, oldValue, newValue);
    }

    public DataDiff(String fieldName, T newValue) {
        this(fieldName, null, newValue);
    }

    @JsonCreator
    public DataDiff(String prefixContext, String fieldName, T oldValue, T newValue) {
        this.fieldName = fieldName;
        this.prefixContext = prefixContext;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public T getOldValue() {
        return this.oldValue;
    }

    String getPrefixContext() {
        return this.prefixContext;
    }

    public String toString() {
        return this.fieldName + '=' + this.newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataDiff dataDiff = (DataDiff)o;
        if (this.fieldName != null ? !this.fieldName.equals(dataDiff.fieldName) : dataDiff.fieldName != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(dataDiff.newValue) : dataDiff.newValue != null) {
            return false;
        }
        if (this.oldValue != null ? !this.oldValue.equals(dataDiff.oldValue) : dataDiff.oldValue != null) {
            return false;
        }
        return this.prefixContext != null ? this.prefixContext.equals(dataDiff.prefixContext) : dataDiff.prefixContext == null;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.prefixContext != null ? this.prefixContext.hashCode() : 0);
        return result;
    }
}

