package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mark an element as "diffable" which is also the default state of an element (unless marked with @DiffIgnore)
 * Use this annotation to configure the output name in the <pre>DiffResult</pre> of two elements.
 *
 * @author Noam Shemesh
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DiffElement {
    String name() default "";
}
