/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class FileChecksumCalculator {
    private static final int BUFFER_SIZE = 32768;

    public static Map<String, String> calculateChecksums(File fileToCalculate, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        if (fileToCalculate == null) {
            throw new IllegalArgumentException("Cannot read checksums of null file.");
        }
        if (!fileToCalculate.exists()) {
            throw new IllegalArgumentException("Cannot read checksums of non-existent file.");
        }
        if (!fileToCalculate.isFile()) {
            throw new IllegalArgumentException("Cannot read checksums of a folder.");
        }
        if (algorithms == null) {
            throw new IllegalArgumentException("Checksum algorithms cannot be null.");
        }
        if (algorithms.length == 0) {
            return Maps.newHashMap();
        }
        return FileChecksumCalculator.calculate(fileToCalculate, algorithms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> calculate(File fileToCalculate, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        HashMap digestMap = Maps.newHashMap();
        HashMap checksumMap = Maps.newHashMap();
        for (String algorithm : algorithms) {
            digestMap.put(algorithm, MessageDigest.getInstance(algorithm));
        }
        FileInputStream inputStream = new FileInputStream(fileToCalculate);
        byte[] buffer = new byte[32768];
        try {
            int size = inputStream.read(buffer, 0, 32768);
            while (size >= 0) {
                for (String algorithm : algorithms) {
                    ((MessageDigest)digestMap.get(algorithm)).update(buffer, 0, size);
                }
                size = inputStream.read(buffer, 0, 32768);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        for (String algorithm : algorithms) {
            byte[] bytes = ((MessageDigest)digestMap.get(algorithm)).digest();
            StringBuilder sb = new StringBuilder();
            for (byte aBinaryData : bytes) {
                String t = Integer.toHexString(aBinaryData & 0xFF);
                if (t.length() == 1) {
                    sb.append("0");
                }
                sb.append(t);
            }
            checksumMap.put(algorithm, sb.toString().trim());
        }
        return checksumMap;
    }
}

