/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.accessrouterclient;

import com.google.common.base.Enums;
import com.jfrog.router.v1.registry.EndpointProtocol;
import com.jfrog.router.v1.registry.HealthCheckEndpoint;
import com.jfrog.router.v1.registry.LocalEndpoint;
import com.jfrog.router.v1.registry.RegisterServiceRequest;
import com.jfrog.router.v1.registry.RoutePath;
import com.jfrog.router.v1.registry.ServiceResourceGrpc;
import com.jfrog.router.v1.registry.UnregisterServiceRequest;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jfrog.access.router.RouterGrpcClient;
import org.jfrog.access.router.registration.RouterRegistrationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClientImpl
implements RouterGrpcClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RouterClientImpl.class);
    private ServiceResourceGrpc.ServiceResourceBlockingStub stub = null;
    private ManagedChannel channel;

    public void registerService(@Nonnull RouterRegistrationData routerRegistrationData) {
        List localEndpoints = routerRegistrationData.getEndpoints().stream().map(endpoint -> LocalEndpoint.newBuilder().setPort(endpoint.getPort()).setProtocol((EndpointProtocol)Enums.getIfPresent(EndpointProtocol.class, (String)endpoint.getProtocol().name()).orNull()).addAllPaths(this.mapToRouterPaths(endpoint.getRoutePaths())).build()).collect(Collectors.toList());
        HealthCheckEndpoint healthCheckEndpoint = HealthCheckEndpoint.newBuilder().setPath(routerRegistrationData.getHealthCheckEndpoint().getPath()).setPort(routerRegistrationData.getHealthCheckEndpoint().getPort()).build();
        RegisterServiceRequest routerRequest = RegisterServiceRequest.newBuilder().setServiceId(routerRegistrationData.getServiceId().getFormattedName()).setNodeId(routerRegistrationData.getNodeId()).addAllEndpoints(localEndpoints).setHealthCheckEndpoint(healthCheckEndpoint).build();
        this.stub().registerService(routerRequest);
    }

    public void unregisterService(@Nonnull RouterRegistrationData routerRegistrationData) {
        UnregisterServiceRequest request = UnregisterServiceRequest.newBuilder().setServiceId(routerRegistrationData.getServiceId().getFormattedName()).setNodeId(routerRegistrationData.getNodeId()).build();
        this.stub().unregisterService(request);
    }

    public void setChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    private ServiceResourceGrpc.ServiceResourceBlockingStub stub() {
        if (this.stub == null) {
            if (this.channel == null) {
                log.error("MUST call setChannel(ManagedChannel channel) before calling here");
            }
            this.stub = ServiceResourceGrpc.newBlockingStub((Channel)this.channel);
        }
        return this.stub;
    }

    private Iterable<? extends RoutePath> mapToRouterPaths(List<org.jfrog.access.router.registration.RoutePath> routePaths) {
        if (routePaths == null || routePaths.isEmpty()) {
            return Collections.emptyList();
        }
        return routePaths.stream().map(route -> RoutePath.newBuilder().setMatch(route.getMatch()).setReplace(route.getReplace()).build()).collect(Collectors.toList());
    }
}

