/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.key.master;

import org.jfrog.access.key.master.MasterKeyStorage;
import org.jfrog.access.key.master.status.DbMasterKeyStatus;
import org.jfrog.access.key.master.status.MasterKeyStatus;
import org.jfrog.access.key.master.status.MasterKeyStatusDao;

public class MasterKeyStorageBase
implements MasterKeyStorage {
    private final MasterKeyStatusDao masterKeyDao;

    public MasterKeyStorageBase(MasterKeyStatusDao masterKeyDao) {
        this.masterKeyDao = masterKeyDao;
    }

    @Override
    public boolean isKeyExists(String keyFingerprint) {
        return this.masterKeyDao.exists(keyFingerprint);
    }

    @Override
    public boolean insertMasterKey(MasterKeyStatus keyStatus) {
        DbMasterKeyStatus.DbMasterKeyStatusEnum status = DbMasterKeyStatus.DbMasterKeyStatusEnum.valueOf(keyStatus.getStatus().name());
        DbMasterKeyStatus dbMasterKeyStatus = new DbMasterKeyStatus(keyStatus.getKid(), status, keyStatus.getSetByNodeId(), keyStatus.getExpires());
        this.masterKeyDao.addMasterKeyStatus(dbMasterKeyStatus);
        return true;
    }

    @Override
    public MasterKeyStatus getMasterKeyInfo() {
        DbMasterKeyStatus key = this.masterKeyDao.getMasterKeyStatus();
        if (key == null) {
            return null;
        }
        MasterKeyStatus.MasterKeyStatusEnum status = MasterKeyStatus.MasterKeyStatusEnum.valueOf(key.getStatus().name());
        return new MasterKeyStatus(key.getKid(), status, key.getSetByNodeId(), key.getExpires());
    }
}

