/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class JoinKeyUtils {
    public static final int MIN_BYTES_LENGTH = 32;

    @Nonnull
    public static String getKeyId(@Nonnull String hexEncodedKey) {
        byte[] decodedKey;
        try {
            decodedKey = Hex.decodeHex((char[])hexEncodedKey.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Failed decoding hex str \"" + hexEncodedKey + "\"", e);
        }
        String sha256hex = DigestUtils.sha256Hex((byte[])decodedKey);
        return sha256hex.substring(0, 6);
    }

    @Nonnull
    public static byte[] getSigningKey(@Nonnull String hexEncodedKey) {
        return JoinKeyUtils.hexDecodeAndPad(hexEncodedKey, 32);
    }

    @Nonnull
    private static byte[] hexDecodeAndPad(@Nonnull String hexEncodedKey, int minSize) {
        byte[] decodedKey;
        if (hexEncodedKey == null) {
            throw new IllegalArgumentException("Could not decode null.");
        }
        try {
            decodedKey = Hex.decodeHex((char[])hexEncodedKey.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Failed decoding hex str.", e);
        }
        return JoinKeyUtils.pkcs7(decodedKey, minSize);
    }

    @Nonnull
    private static byte[] pkcs7(@Nonnull byte[] unpaddedKey, int blockSize) {
        int padLength = unpaddedKey.length == 0 ? blockSize : (blockSize - unpaddedKey.length % blockSize) % blockSize;
        byte[] paddedKey = new byte[unpaddedKey.length + padLength];
        System.arraycopy(unpaddedKey, 0, paddedKey, 0, unpaddedKey.length);
        byte[] padding = new byte[padLength];
        Arrays.fill(padding, (byte)padLength);
        System.arraycopy(padding, 0, paddedKey, unpaddedKey.length, padding.length);
        return paddedKey;
    }
}

