/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jfrog.access.model.CustomEnum;
import org.jfrog.common.ArgUtils;
import org.jfrog.common.config.diff.GenerateDiffFunction;

@GenerateDiffFunction
public class Realm
implements CustomEnum {
    public static final Realm INTERNAL = new Realm("internal");
    public static final Realm LDAP = new Realm("ldap");
    public static final Realm SAML = new Realm("saml");
    public static final Realm CROWD = new Realm("crowd");
    private static final List<Realm> PREDEFINED_REALMS = Arrays.asList(INTERNAL, LDAP, SAML, CROWD);
    private static final ConcurrentMap<String, Realm> REALMS = new ConcurrentHashMap(PREDEFINED_REALMS.stream().collect(Collectors.toMap(Realm::getName, Function.identity())));
    private final String name;

    private Realm(@Nonnull String name) {
        this.name = ArgUtils.requireNonBlank((String)name, (String)"Realm name is required").toLowerCase();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public static Realm valueOf(@Nonnull String name) {
        return REALMS.computeIfAbsent(name.toLowerCase(), Realm::new);
    }

    @Nonnull
    public static Collection<Realm> predefinedRealms() {
        return PREDEFINED_REALMS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Realm realm = (Realm)o;
        return this.name.equals(realm.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

