/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jfrog.access.common.ServiceId;

public class SubjectFQN {
    public static final String USERS_NAME_PART = "users";
    private final ServiceId serviceId;
    private final List<String> nameParts;

    public SubjectFQN(@Nonnull ServiceId serviceId, String ... nameParts) {
        this.serviceId = Objects.requireNonNull(serviceId, "Service ID is required");
        this.nameParts = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(nameParts)));
    }

    @Nonnull
    public ServiceId getServiceId() {
        return this.serviceId;
    }

    @Nonnull
    public List<String> getNameParts() {
        return this.nameParts;
    }

    @Nonnull
    public String getFormattedName() {
        StringBuilder sb = new StringBuilder(this.serviceId.getFormattedName());
        if (!this.nameParts.isEmpty()) {
            sb.append("/").append(String.join((CharSequence)"/", this.nameParts));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFormattedName();
    }

    @Nonnull
    public static SubjectFQN fromFullyQualifiedName(@Nonnull String fqName) {
        String[] parts = fqName.split("/");
        ServiceId serviceId = ServiceId.fromFormattedName(parts[0]);
        String[] nameParts = Arrays.copyOfRange(parts, 1, parts.length);
        return new SubjectFQN(serviceId, nameParts);
    }

    public static boolean isUserTokenSubject(String subject) {
        try {
            return StringUtils.isNotBlank((String)SubjectFQN.extractUsername(subject));
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nonnull
    public static String extractUsername(String subject) {
        String[] parts = subject.split("users/");
        if (parts.length == 2 && !parts[1].contains("/")) {
            return parts[1];
        }
        throw new IllegalArgumentException("Unexpected subject (not a user token): " + subject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectFQN that = (SubjectFQN)o;
        return this.getFormattedName().equals(that.getFormattedName());
    }

    public int hashCode() {
        return this.getFormattedName().hashCode();
    }
}

