/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jfrog.access.common.Scope;
import org.jfrog.access.common.ServiceId;
import org.jfrog.access.token.exception.TokenScopeException;
import org.jfrog.access.util.TokenScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScopeContainer.class);
    private static final String RESOURCE_PERMISSION_DELIMITER = ":";
    private static final String USER_PERMISSION_GROUP = "*";
    public static final String APPLIED_PERMISSIONS_USER_SCOPE = "applied-permissions/user";
    private static final String MEMBER_OF_GROUPS_RESOURCE = "member-of-groups";
    public static final String LEGACY_APPLIED_PERMISSIONS_GROUP_SCOPE = "member-of-groups:";
    public static final String LEGACY_APPLIED_PERMISSIONS_USER_SCOPE = "member-of-groups:*";
    private static final String APPLIED_PERMISSIONS_GROUPS = "applied-permissions/groups";
    public static final String APPLIED_PERMISSIONS_GROUP_SCOPE = "applied-permissions/groups:";
    private static final String GROUP_DELIMITER = ",";
    public static final String ADMIN_PERMISSION = "applied-permissions/admin";
    private static final String OLD_ADMIN_PERMISSION = "admin";
    private Map<String, Scope> scopeMap = new HashMap<String, Scope>();
    private boolean hasUserPermission = false;
    private boolean isAdmin = false;

    public static ScopeContainer create(String allScopes) {
        ScopeContainer container = new ScopeContainer();
        container.addAll(allScopes);
        return container;
    }

    public void addAll(String allScopes) {
        TokenScopeUtils.scopeToList(allScopes).forEach(this::add);
    }

    public void addAllRaw(String allScopes) {
        TokenScopeUtils.scopeToList(allScopes).forEach(this::addRaw);
    }

    public void add(String scopeStr) {
        boolean alreadyAdded = this.processSpecial(scopeStr);
        if (!alreadyAdded) {
            this.doAddScope(scopeStr, false);
        }
    }

    public void addRaw(String scopeStr) {
        this.processSpecial(scopeStr);
        this.doAddScope(scopeStr, true);
    }

    public void add(Scope scope) {
        if (this.scopeMap.containsKey(this.getName(scope))) {
            log.debug("Scope is malformed, {} is repeated, ignoring repeats", (Object)this.getName(scope));
            return;
        }
        this.scopeMap.put(this.getName(scope), scope);
    }

    public Set<String> getGroups() {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.addAll(this.getGroups(this.scopeMap.get(MEMBER_OF_GROUPS_RESOURCE)));
        groups.addAll(this.getGroups(this.scopeMap.get(APPLIED_PERMISSIONS_GROUPS)));
        return groups;
    }

    public boolean hasUserPermission() {
        return this.hasUserPermission;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    private boolean processSpecial(String scopeStr) {
        switch (scopeStr) {
            case "applied-permissions/user": {
                this.hasUserPermission = true;
                return true;
            }
            case "applied-permissions/admin": 
            case "admin": {
                this.isAdmin = true;
                return true;
            }
        }
        return false;
    }

    private void doAddScope(String scopeStr, boolean keepUserPermission) {
        Scope scope = this.toScope(scopeStr);
        if (!this.processOldUsers(scope, keepUserPermission) && !this.processOldAdmin(scope, keepUserPermission)) {
            this.add(scope);
        }
    }

    private boolean processOldUsers(Scope scope, boolean keepUserPermission) {
        Collection<? extends String> groups;
        if (MEMBER_OF_GROUPS_RESOURCE.equals(scope.getResource()) && (groups = this.getGroups(scope)).contains(USER_PERMISSION_GROUP)) {
            this.hasUserPermission = true;
            if (!keepUserPermission) {
                if (groups.size() > 1) {
                    String permission = scope.getPermission();
                    permission = permission.replaceAll(",\\s*\\*\\s*", "");
                    permission = permission.replaceAll("\\s*\\*\\s*,?", "");
                    permission = permission.replaceAll("^\\s*\\*\\s*$", "");
                    this.add(new Scope(scope.getResource(), permission));
                }
            } else {
                this.add(scope);
            }
            return true;
        }
        return false;
    }

    private boolean processOldAdmin(Scope scope, boolean keepUserPermission) {
        if (scope.getResource() != null && this.isServiceId(scope.getResource()) && OLD_ADMIN_PERMISSION.equals(scope.getPermission())) {
            this.isAdmin = true;
            if (keepUserPermission) {
                this.add(scope);
            }
            return true;
        }
        return false;
    }

    private boolean isServiceId(String resource) {
        try {
            ServiceId.fromFormattedName(resource);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Scope toScope(String scopeStr) {
        Scope scope;
        String[] parts = scopeStr.split(RESOURCE_PERMISSION_DELIMITER);
        switch (parts.length) {
            case 1: {
                scope = new Scope(parts[0]);
                break;
            }
            case 2: {
                scope = new Scope(parts[0], parts[1]);
                break;
            }
            case 3: {
                scope = new Scope(parts[0] + "/" + parts[1], parts[2]);
                break;
            }
            default: {
                throw new TokenScopeException("sub-scope is malformed: " + parts);
            }
        }
        return scope;
    }

    private Collection<? extends String> getGroups(Scope scope) {
        if (scope == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(scope.getPermission().replaceAll("^\"|\"$", "").split(GROUP_DELIMITER)).stream().map(String::trim).collect(Collectors.toUnmodifiableList());
    }

    private String getName(Scope scope) {
        if (scope.getResource() != null) {
            return scope.getResource();
        }
        return scope.getPermission();
    }
}

