/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import javax.annotation.Nonnull;
import lombok.Generated;
import org.jfrog.access.common.ServiceId;

public class Issuer {
    public static final String USERS_PART = "/users/";
    private ServiceId serviceId;
    private String issuedBy;

    public Issuer(@Nonnull String issuer) {
        String[] serviceIdParts;
        String[] parts = issuer.split(USERS_PART);
        if (parts.length == 2) {
            this.issuedBy = parts[1];
        }
        if ((serviceIdParts = parts[0].split("@")).length != 2) {
            throw new IllegalArgumentException("Invalid issuer: " + issuer);
        }
        this.serviceId = new ServiceId(ServiceId.requireValidElement(serviceIdParts[0]), ServiceId.requireValidElement(serviceIdParts[1]));
    }

    @Generated
    public ServiceId getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getIssuedBy() {
        return this.issuedBy;
    }
}

