/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jfrog.access.common.Action;
import org.jfrog.access.common.ResourceType;
import org.jfrog.access.common.ServiceId;
import org.jfrog.common.config.diff.DiffFunctions;

public class DiffFunctionsImpl
implements DiffFunctions {
    Map<String, BiFunction<Object, Object, DiffResult>> diffFunctions = new HashMap<String, BiFunction<Object, Object, DiffResult>>();

    public <T> DiffResult diffFor(Class<T> c, T object, T other) {
        return this.diffFunctions.get(c.getSimpleName()).apply(object, other);
    }

    public <T> boolean containsClass(Class<T> c) {
        return this.diffFunctions.containsKey(c.getSimpleName());
    }

    private DiffResult serviceId(ServiceId object, ServiceId other) {
        DiffBuilder db = new DiffBuilder((Object)object, (Object)other, ToStringStyle.DEFAULT_STYLE, false);
        db.append("instanceId", (Object)object.getInstanceId(), (Object)other.getInstanceId());
        db.append("serviceType", (Object)object.getServiceType(), (Object)other.getServiceType());
        return db.build();
    }

    private DiffResult resourceType(ResourceType object, ResourceType other) {
        DiffBuilder db = new DiffBuilder((Object)object, (Object)other, ToStringStyle.DEFAULT_STYLE, false);
        db.append("key", (Object)object.getKey(), (Object)other.getKey());
        return db.build();
    }

    private DiffResult action(Action object, Action other) {
        DiffBuilder db = new DiffBuilder((Object)object, (Object)other, ToStringStyle.DEFAULT_STYLE, false);
        db.append("code", (Object)object.getCode(), (Object)other.getCode());
        return db.build();
    }

    public DiffFunctionsImpl() {
        this.diffFunctions.put("ServiceId", (object, other) -> this.serviceId((ServiceId)object, (ServiceId)other));
        this.diffFunctions.put("ResourceType", (object, other) -> this.resourceType((ResourceType)((Object)((Object)object)), (ResourceType)((Object)((Object)other))));
        this.diffFunctions.put("Action", (object, other) -> this.action((Action)((Object)((Object)object)), (Action)((Object)((Object)other))));
    }
}

