/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Scope {
    private final String resource;
    private final String permission;

    public Scope(@Nonnull String permission) {
        this(null, permission);
    }

    public Scope(String resource, @Nonnull String permission) {
        this.resource = StringUtils.isBlank((CharSequence)resource) ? "*" : StringUtils.trim((String)resource);
        this.permission = StringUtils.trimToNull((String)permission);
        if (this.permission == null) {
            throw new IllegalArgumentException("Scope permission cannot be empty");
        }
    }

    @Nullable
    public String getResource() {
        return this.resource;
    }

    @Nonnull
    public String getPermission() {
        return this.permission;
    }

    public static Scope parse(@Nonnull String scope) {
        Objects.requireNonNull(scope, "Cannot parse null scope string");
        String[] parts = StringUtils.split((String)StringUtils.trim((String)scope), (String)":");
        switch (parts.length) {
            case 0: {
                throw new IllegalArgumentException("Cannot parse scope string: '" + scope + "'. No parts found.");
            }
            case 1: {
                return new Scope(parts[0]);
            }
            case 2: {
                return new Scope(parts[0], parts[1]);
            }
        }
        throw new IllegalArgumentException("Cannot parse scope string: '" + scope + "'. Too many parts.");
    }

    public String toString() {
        return this.resource == null ? this.permission : this.resource + ":" + this.permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        return Objects.equals(this.resource, scope.resource) && Objects.equals(this.permission, scope.permission);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.permission);
    }
}

