/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client.token;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jfrog.access.common.ServiceId;
import org.jfrog.access.token.JwtAccessToken;

public class TokenRequest {
    private final String subject;
    private final List<String> scope;
    private final boolean refreshable;
    private final String issuer;
    private final Long expiresIn;
    private final String extension;
    private final List<String> audience;

    public TokenRequest(@Nonnull List<String> scope, boolean refreshable, @Nullable String subject, String issuer, @Nullable Long expiresIn, @Nullable String extension, @Nullable List<String> audience) {
        this.scope = JwtAccessToken.requireValidScopeFormat(scope);
        this.refreshable = refreshable;
        this.subject = subject;
        this.issuer = issuer;
        this.expiresIn = expiresIn;
        this.extension = extension;
        this.audience = audience;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    @Nonnull
    public List<String> getScope() {
        return Collections.unmodifiableList(this.scope);
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    @Nullable
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nonnull
    public List<String> getAudience() {
        return this.audience == null ? Collections.emptyList() : Collections.unmodifiableList(this.audience);
    }

    @Nonnull
    public String toQueryParams() {
        StringBuilder query = new StringBuilder().append("scope=").append(this.urlEncoded(String.join((CharSequence)" ", this.scope))).append("&refreshable=").append(this.refreshable);
        if (this.subject != null) {
            query.append("&username=").append(this.urlEncoded(this.subject));
        }
        if (this.expiresIn != null) {
            query.append("&expires_in=").append(this.expiresIn);
        }
        if (this.extension != null) {
            query.append("&extension=").append(this.urlEncoded(this.extension));
        }
        if (this.audience != null && !this.audience.isEmpty()) {
            query.append("&audience=").append(this.urlEncoded(String.join((CharSequence)" ", this.audience)));
        }
        return query.toString();
    }

    private String urlEncoded(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toQueryParams();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder scopes(@Nonnull List<String> scope) {
        return new Builder(Optional.ofNullable(scope).orElseThrow(() -> new IllegalArgumentException("scope is required")));
    }

    public static Builder scopes(@Nonnull String scopeToken, String ... more) {
        return new Builder(scopeToken, more);
    }

    public static Builder scopes(@Nonnull TokenRequest tokenRequest) {
        return new Builder(tokenRequest.getScope()).subject(tokenRequest.getSubject()).refreshable(tokenRequest.isRefreshable()).expiresIn(tokenRequest.getExpiresIn()).extension(tokenRequest.getExtension()).audience(tokenRequest.getAudience());
    }

    public static class Builder {
        private final List<String> scope = new ArrayList<String>();
        private String subject = null;
        private String issuer = null;
        private boolean refreshable = false;
        private Long expiresIn = null;
        private String extension = null;
        private List<String> audience = null;

        public Builder() {
        }

        public Builder(@Nonnull List<String> scope) {
            this.scopes(scope);
        }

        public Builder(@Nonnull String scopeToken, String ... more) {
            this.scopes(scopeToken, more);
        }

        public Builder scopes(@Nonnull List<String> scopes) {
            this.scope.addAll(scopes);
            return this;
        }

        public Builder scopes(@Nonnull String scopeToken, String ... more) {
            this.scope.add(scopeToken);
            this.scope.addAll(Arrays.asList(more));
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder refreshable() {
            return this.refreshable(true);
        }

        public Builder nonRefreshable() {
            return this.refreshable(false);
        }

        public Builder refreshable(boolean refreshable) {
            this.refreshable = refreshable;
            return this;
        }

        public Builder expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder noExpiry() {
            this.expiresIn = 0L;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder audience(List<String> audience) {
            this.audience = audience;
            return this;
        }

        public Builder audience(@Nonnull ServiceId audience, ServiceId ... other) {
            this.audience = new ArrayList<String>();
            this.audience.add(audience.getFormattedName());
            Stream.of(other).map(ServiceId::getFormattedName).forEach(this.audience::add);
            return this;
        }

        public Builder audience(@Nonnull String audience, String ... other) {
            this.audience = new ArrayList<String>();
            this.audience.add(audience);
            Stream.of(other).forEach(this.audience::add);
            return this;
        }

        public TokenRequest build() {
            if (this.scope.isEmpty()) {
                throw new IllegalArgumentException("scope is required");
            }
            return new TokenRequest(this.scope, this.refreshable, this.subject, this.issuer, this.expiresIn, this.extension, this.audience);
        }
    }
}

