/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client;

import org.apache.commons.lang3.StringUtils;
import org.jfrog.access.client.AccessClientException;
import org.jfrog.access.client.model.ErrorsModel;
import org.jfrog.common.JsonParsingException;
import org.jfrog.common.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessClientHttpException
extends AccessClientException {
    private static final Logger log = LoggerFactory.getLogger(AccessClientHttpException.class);
    private final int statusCode;
    private final ErrorsModel errorsModel;

    public AccessClientHttpException(int statusCode, String message) {
        super("HTTP response status " + statusCode + ":" + message);
        this.errorsModel = this.accessClientHttpException(message, message);
        this.statusCode = statusCode;
    }

    public AccessClientHttpException(int statusCode, String message, String body) {
        super("HTTP response status " + statusCode + ":" + message);
        this.errorsModel = this.accessClientHttpException(message, body);
        this.statusCode = statusCode;
    }

    private ErrorsModel accessClientHttpException(String message, String body) {
        ErrorsModel internalErrorModel = null;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            try {
                internalErrorModel = (ErrorsModel)JsonUtils.getInstance().readValue(body, ErrorsModel.class);
            }
            catch (JsonParsingException e) {
                log.warn("Unrecognized ErrorsModel by Access. Original message: {}", (Object)message);
                log.debug("", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Couldn't parse ErrorsModel from Access. Original message: {}", (Object)message);
                log.debug("", (Throwable)e);
            }
        }
        return internalErrorModel;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorsModel getErrorsModel() {
        return this.errorsModel;
    }
}

