/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svgToScene;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import jetbrains.datalore.base.unsupported.UnsupportedKt;
import jetbrains.datalore.vis.svgToScene.ParsingUtil;
import jetbrains.datalore.vis.svgToScene.ToRadiansKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"MATRIX_11", "", "MATRIX_12", "MATRIX_21", "MATRIX_22", "MATRIX_DX", "MATRIX_DY", "ROTATE_ANGLE", "ROTATE_X", "ROTATE_Y", "SCALE_X", "SCALE_Y", "SKEW_X_ANGLE", "SKEW_Y_ANGLE", "TRANSLATE_X", "TRANSLATE_Y", "parseSvgTransform", "", "Ljavafx/scene/transform/Transform;", "svgTransform", "", "vis-canvas"})
public final class SvgTransformToSceneKt {
    private static final int SCALE_X = 0;
    private static final int SCALE_Y = 1;
    private static final int SKEW_X_ANGLE = 0;
    private static final int SKEW_Y_ANGLE = 0;
    private static final int ROTATE_ANGLE = 0;
    private static final int ROTATE_X = 1;
    private static final int ROTATE_Y = 2;
    private static final int TRANSLATE_X = 0;
    private static final int TRANSLATE_Y = 1;
    private static final int MATRIX_11 = 0;
    private static final int MATRIX_12 = 1;
    private static final int MATRIX_21 = 2;
    private static final int MATRIX_22 = 3;
    private static final int MATRIX_DX = 4;
    private static final int MATRIX_DY = 5;

    @NotNull
    public static final List<Transform> parseSvgTransform(@NotNull String svgTransform) {
        Intrinsics.checkNotNullParameter((Object)svgTransform, (String)"svgTransform");
        List<ParsingUtil.Result> results = ParsingUtil.INSTANCE.parseTransform(svgTransform);
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        for (ParsingUtil.Result res : results) {
            Transform transform2;
            switch (res.getName()) {
                case "scale": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double scaleX = d;
                    Double d2 = res.getParam(1);
                    double scaleY = d2 != null ? d2 : scaleX;
                    transform2 = (Transform)new Scale(scaleX, scaleY);
                    break;
                }
                case "skewX": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double angle = d;
                    double d3 = ToRadiansKt.toRadians(angle);
                    boolean bl = false;
                    double factor = Math.sin(d3);
                    transform2 = (Transform)new Shear(factor, 0.0);
                    break;
                }
                case "skewY": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double angle = d;
                    double d3 = ToRadiansKt.toRadians(angle);
                    boolean bl = false;
                    double factor = Math.sin(d3);
                    transform2 = (Transform)new Shear(0.0, factor);
                    break;
                }
                case "rotate": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    Rotate rotate = new Rotate(d.doubleValue());
                    if (res.getParamCount() == 3) {
                        Double d4 = res.getParam(1);
                        Intrinsics.checkNotNull((Object)d4);
                        rotate.setPivotX(d4.doubleValue());
                        Double d5 = res.getParam(2);
                        Intrinsics.checkNotNull((Object)d5);
                        rotate.setPivotY(d5.doubleValue());
                    }
                    transform2 = (Transform)rotate;
                    break;
                }
                case "translate": {
                    Double d = res.getParam(0);
                    Intrinsics.checkNotNull((Object)d);
                    double dX = d;
                    Double d6 = res.getParam(1);
                    double dY = d6 != null ? d6 : 0.0;
                    transform2 = (Transform)new Translate(dX, dY);
                    break;
                }
                case "matrix": {
                    Void void_ = UnsupportedKt.UNSUPPORTED("We don't use MATRIX");
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown transform: " + res.getName());
                }
            }
            Transform transform3 = transform2;
            transforms.add(transform3);
        }
        return transforms;
    }
}

