/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.Stat;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.GeomLayerBuilder;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.builder.assemble.geom.GeomProvider;
import jetbrains.datalore.plot.builder.interact.GeomInteraction;
import jetbrains.datalore.plot.config.GeoConfigKt;
import jetbrains.datalore.plot.config.GeomInteractionUtil;
import jetbrains.datalore.plot.config.GeomProto;
import jetbrains.datalore.plot.config.GeomProtoClientSide;
import jetbrains.datalore.plot.config.LayerConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.config.ScaleConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J/\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\t\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/config/PlotConfigClientSideUtil;", "", "()V", "buildPlotLayers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "plotConfig", "Ljetbrains/datalore/plot/config/PlotConfigClientSide;", "createGuideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "scaleConfigs", "Ljetbrains/datalore/plot/config/ScaleConfig;", "createGuideOptionsMap$plot_config_portable", "createLayerBuilder", "Ljetbrains/datalore/plot/builder/assemble/GeomLayerBuilder;", "layerConfig", "Ljetbrains/datalore/plot/config/LayerConfig;", "geomInteraction", "Ljetbrains/datalore/plot/builder/interact/GeomInteraction;", "createPlotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "opts", "", "plot-config-portable"})
public final class PlotConfigClientSideUtil {
    public static final PlotConfigClientSideUtil INSTANCE;

    @NotNull
    public final Map<Aes<?>, GuideOptions> createGuideOptionsMap$plot_config_portable(@NotNull List<? extends ScaleConfig<?>> scaleConfigs) {
        Intrinsics.checkNotNullParameter(scaleConfigs, (String)"scaleConfigs");
        HashMap guideOptionsByAes = new HashMap();
        for (ScaleConfig<?> scaleConfig : scaleConfigs) {
            if (!scaleConfig.hasGuideOptions()) continue;
            GuideOptions guideOptions = scaleConfig.gerGuideOptions().createGuideOptions();
            ((Map)guideOptionsByAes).put(scaleConfig.getAes(), guideOptions);
        }
        return guideOptionsByAes;
    }

    @NotNull
    public final PlotAssembler createPlotAssembler(@NotNull Map<String, ? extends Object> opts) {
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        PlotConfigClientSide config = PlotConfigClientSide.Companion.create(opts);
        List<List<GeomLayer>> layersByTile = this.buildPlotLayers(config);
        PlotAssembler assembler2 = PlotAssembler.Companion.multiTile(config.getScaleMap(), layersByTile, config.getCoordProvider$plot_config_portable(), config.getTheme$plot_config_portable());
        assembler2.setTitle(config.getTitle());
        assembler2.setGuideOptionsMap(config.getGuideOptionsMap$plot_config_portable());
        assembler2.setFacets(config.getFacets());
        return assembler2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<GeomLayer>> buildPlotLayers(PlotConfigClientSide plotConfig) {
        ArrayList<DataFrame> dataByLayer = new ArrayList<DataFrame>();
        for (LayerConfig layerConfig : plotConfig.getLayerConfigs()) {
            DataFrame layerData = layerConfig.getCombinedData();
            dataByLayer.add(layerData);
        }
        Iterator<List<DataFrame>> layersDataByTile = PlotConfigUtil.INSTANCE.toLayersDataByTile((List<DataFrame>)dataByLayer, plotConfig.getFacets()).iterator();
        ArrayList<GeomLayerBuilder> layerBuilders = new ArrayList<GeomLayerBuilder>();
        ArrayList layersByTile = new ArrayList();
        while (layersDataByTile.hasNext()) {
            boolean bl;
            boolean isMultilayer;
            List<DataFrame> tileDataByLayer;
            ArrayList<GeomLayer> panelLayers;
            block7: {
                panelLayers = new ArrayList<GeomLayer>();
                tileDataByLayer = layersDataByTile.next();
                isMultilayer = tileDataByLayer.size() > 1;
                Iterable $this$any$iv = plotConfig.getLayerConfigs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LayerConfig it = (LayerConfig)element$iv;
                        boolean bl2 = false;
                        if (!(it.getGeomProto().getGeomKind() == GeomKind.LIVE_MAP)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            boolean isLiveMap = bl;
            int $this$any$iv = 0;
            int n = ((Collection)tileDataByLayer).size();
            while ($this$any$iv < n) {
                void layerIndex;
                Preconditions.INSTANCE.checkState(layerBuilders.size() >= layerIndex);
                if (layerBuilders.size() == layerIndex) {
                    LayerConfig layerConfig = plotConfig.getLayerConfigs().get((int)layerIndex);
                    GeomInteraction geomInteraction = GeomInteractionUtil.INSTANCE.configGeomTargets$plot_config_portable(layerConfig, plotConfig.getScaleMap(), isMultilayer, isLiveMap, plotConfig.getTheme$plot_config_portable());
                    layerBuilders.add(this.createLayerBuilder(layerConfig, geomInteraction));
                }
                DataFrame layerTileData = tileDataByLayer.get((int)layerIndex);
                GeomLayer layer = ((GeomLayerBuilder)layerBuilders.get((int)layerIndex)).build(layerTileData, plotConfig.getScaleMap());
                panelLayers.add(layer);
                ++layerIndex;
            }
            layersByTile.add(panelLayers);
        }
        return layersByTile;
    }

    private final GeomLayerBuilder createLayerBuilder(LayerConfig layerConfig, GeomInteraction geomInteraction) {
        Object it;
        boolean bl;
        GeomProto geomProto = layerConfig.getGeomProto();
        if (geomProto == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.config.GeomProtoClientSide");
        }
        GeomProvider geomProvider2 = ((GeomProtoClientSide)geomProto).geomProvider(layerConfig);
        Stat stat = layerConfig.getStat();
        GeomLayerBuilder layerBuilder = new GeomLayerBuilder().stat(stat).geom(geomProvider2).pos(layerConfig.getPosProvider());
        Map<Aes<?>, Object> constantAesMap = layerConfig.getConstantsMap();
        Iterator<Aes<?>> iterator2 = constantAesMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Aes<?> aes;
            Aes<?> aes2 = aes = iterator2.next();
            if (aes2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Aes<kotlin.Any>");
            }
            Object object = constantAesMap.get(aes);
            Intrinsics.checkNotNull((Object)object);
            layerBuilder.addConstantAes(aes2, object);
        }
        if (layerConfig.hasExplicitGrouping()) {
            String string = layerConfig.getExplicitGroupingVarName();
            Intrinsics.checkNotNull((Object)string);
            layerBuilder.groupingVarName(string);
        }
        DataFrame.Variable variable = DataFrameUtil.INSTANCE.variables(layerConfig.getCombinedData()).get("__geo_id__");
        if (variable != null) {
            DataFrame.Variable variable2 = variable;
            boolean bl2 = false;
            bl = false;
            it = variable2;
            boolean bl3 = false;
            layerBuilder.pathIdVarName("__geo_id__");
        }
        String string = GeoConfigKt.dataJoinVariable(layerConfig.getMergedOptions());
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            bl = false;
            it = string2;
            boolean bl5 = false;
            layerBuilder.pathIdVarName((String)it);
        }
        List<VarBinding> list2 = layerConfig.getVarBindings();
        for (VarBinding binding : list2) {
            layerBuilder.addBinding(binding);
        }
        layerBuilder.disableLegend(layerConfig.isLegendDisabled());
        layerBuilder.locatorLookupSpec(geomInteraction.createLookupSpec()).contextualMappingProvider(geomInteraction);
        return layerBuilder;
    }

    private PlotConfigClientSideUtil() {
    }

    static {
        PlotConfigClientSideUtil plotConfigClientSideUtil;
        INSTANCE = plotConfigClientSideUtil = new PlotConfigClientSideUtil();
    }
}

