/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.text;

import jetbrains.datalore.base.numberFormat.NumberFormat;
import jetbrains.datalore.plot.common.data.DataType;
import jetbrains.datalore.plot.common.text.DateTimeFormatUtil;
import jetbrains.datalore.plot.common.text.Formatter;
import jetbrains.datalore.plot.common.text.Formatter$WhenMappings;
import jetbrains.datalore.plot.common.time.interval.TimeInterval;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001c\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0015\u001a\u00020\u0004J\u001c\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/common/text/Formatter;", "", "()V", "DATE_MEDIUM", "", "DATE_MEDIUM_TIME_SHORT", "DEF_NUMBER_FORMAT", "Ljetbrains/datalore/base/numberFormat/NumberFormat;", "DEF_NUMBER_FORMATTER", "Lkotlin/Function1;", "YEAR", "YEAR_MONTH", "YEAR_QUARTER", "nullable", "f", "nullString", "tableCell", "dataType", "Ljetbrains/datalore/plot/common/data/DataType;", "tableCellImpl", "time", "pattern", "tooltip", "tooltipImpl", "plot-common-portable"})
public final class Formatter {
    private static final String YEAR = "%b %Y";
    private static final String YEAR_QUARTER = "Q %y";
    private static final String YEAR_MONTH = "%B %Y";
    private static final String DATE_MEDIUM = "%a, %b %e, %Y";
    private static final String DATE_MEDIUM_TIME_SHORT = "%a, %b %e, %Y %l:%M %p";
    private static final NumberFormat DEF_NUMBER_FORMAT;
    private static final Function1<Object, String> DEF_NUMBER_FORMATTER;
    public static final Formatter INSTANCE;

    @NotNull
    public final Function1<Object, String> time(@NotNull String pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        return (Function1)new Function1<Object, String>(pattern2){
            final /* synthetic */ String $pattern;

            @NotNull
            public final String invoke(@NotNull Object input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return DateTimeFormatUtil.INSTANCE.formatDateUTC((Number)input, this.$pattern);
            }
            {
                this.$pattern = string;
                super(1);
            }
        };
    }

    @NotNull
    public final Function1<Object, String> tooltip(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return this.nullable(this.tooltipImpl(dataType), "null");
    }

    private final Function1<Object, String> tooltipImpl(DataType dataType) {
        Function1<Object, String> function1;
        switch (Formatter$WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                function1 = DEF_NUMBER_FORMATTER;
                break;
            }
            case 2: {
                function1 = tooltipImpl.1.INSTANCE;
                break;
            }
            case 3: {
                function1 = this.time(DATE_MEDIUM_TIME_SHORT);
                break;
            }
            case 4: {
                function1 = this.time(DATE_MEDIUM);
                break;
            }
            case 5: {
                function1 = this.time(YEAR_MONTH);
                break;
            }
            case 6: 
            case 7: {
                function1 = this.time(YEAR_QUARTER);
                break;
            }
            case 8: {
                function1 = this.time(YEAR);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function1;
    }

    @NotNull
    public final Function1<Object, String> tableCell(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return this.tableCell(dataType, "null");
    }

    private final Function1<Object, String> tableCell(DataType dataType, String nullString) {
        return this.nullable(this.tableCellImpl(dataType), nullString);
    }

    private final Function1<Object, String> tableCellImpl(DataType dataType) {
        switch (Formatter$WhenMappings.$EnumSwitchMapping$1[dataType.ordinal()]) {
            case 1: {
                return DEF_NUMBER_FORMATTER;
            }
            case 2: {
                return tableCellImpl.1.INSTANCE;
            }
            case 3: {
                return this.time("%a, %b %e, '%y");
            }
        }
        if (dataType.isTimeInterval()) {
            TimeInterval timeInterval = TimeInterval.Companion.fromIntervalDataType(dataType);
            return timeInterval.getTickFormatter();
        }
        throw (Throwable)new IllegalArgumentException("Can't create formatter for data type " + (Object)((Object)dataType));
    }

    private final Function1<Object, String> nullable(Function1<Object, String> f, String nullString) {
        return (Function1)new Function1<Object, String>(nullString, f){
            final /* synthetic */ String $nullString;
            final /* synthetic */ Function1 $f;

            @NotNull
            public final String invoke(@Nullable Object input) {
                return input == null ? this.$nullString : (String)this.$f.invoke(input);
            }
            {
                this.$nullString = string;
                this.$f = function1;
                super(1);
            }
        };
    }

    private Formatter() {
    }

    static {
        Formatter formatter;
        INSTANCE = formatter = new Formatter();
        DEF_NUMBER_FORMAT = new NumberFormat(",g");
        DEF_NUMBER_FORMATTER = DEF_NUMBER_FORMATTER.1.INSTANCE;
    }

    public static final /* synthetic */ NumberFormat access$getDEF_NUMBER_FORMAT$p(Formatter $this) {
        Formatter formatter = $this;
        return DEF_NUMBER_FORMAT;
    }
}

