/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling;

import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.sampling.PointSampling;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.builder.sampling.method.GroupRandomSampling;
import jetbrains.datalore.plot.builder.sampling.method.GroupSystematicSampling;
import jetbrains.datalore.plot.builder.sampling.method.PickSampling;
import jetbrains.datalore.plot.builder.sampling.method.RandomSampling;
import jetbrains.datalore.plot.builder.sampling.method.RandomStratifiedSampling;
import jetbrains.datalore.plot.builder.sampling.method.SystematicSampling;
import jetbrains.datalore.plot.builder.sampling.method.VertexSampling;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/builder/sampling/Samplings;", "", "()V", "NONE", "Ljetbrains/datalore/plot/builder/sampling/PointSampling;", "getNONE", "()Ljetbrains/datalore/plot/builder/sampling/PointSampling;", "PICK", "", "RANDOM", "RANDOM_GROUP", "RANDOM_STRATIFIED", "SYSTEMATIC", "SYSTEMATIC_GROUP", "VERTEX_DP", "VERTEX_VW", "pick", "sampleSize", "", "random", "seed", "", "(ILjava/lang/Long;)Ljetbrains/datalore/plot/builder/sampling/PointSampling;", "randomGroup", "Ljetbrains/datalore/plot/builder/sampling/Sampling;", "(ILjava/lang/Long;)Ljetbrains/datalore/plot/builder/sampling/Sampling;", "randomStratified", "minSubSample", "(ILjava/lang/Long;Ljava/lang/Integer;)Ljetbrains/datalore/plot/builder/sampling/Sampling;", "systematic", "systematicGroup", "vertexDp", "vertexVw", "NoneSampling", "plot-builder-portable"})
public final class Samplings {
    @NotNull
    public static final String RANDOM = "random";
    @NotNull
    public static final String PICK = "pick";
    @NotNull
    public static final String SYSTEMATIC = "systematic";
    @NotNull
    public static final String RANDOM_GROUP = "group_random";
    @NotNull
    public static final String SYSTEMATIC_GROUP = "group_systematic";
    @NotNull
    public static final String RANDOM_STRATIFIED = "random_stratified";
    @NotNull
    public static final String VERTEX_VW = "vertex_vw";
    @NotNull
    public static final String VERTEX_DP = "vertex_dp";
    @NotNull
    private static final PointSampling NONE;
    public static final Samplings INSTANCE;

    @NotNull
    public final PointSampling getNONE() {
        return NONE;
    }

    @NotNull
    public final PointSampling random(int sampleSize, @Nullable Long seed) {
        return new RandomSampling(sampleSize, seed);
    }

    @NotNull
    public final PointSampling pick(int sampleSize) {
        return new PickSampling(sampleSize);
    }

    @NotNull
    public final Sampling vertexDp(int sampleSize) {
        return new VertexSampling.VertexDpSampling(sampleSize);
    }

    @NotNull
    public final Sampling vertexVw(int sampleSize) {
        return new VertexSampling.VertexVwSampling(sampleSize);
    }

    @NotNull
    public final Sampling systematic(int sampleSize) {
        return new SystematicSampling(sampleSize);
    }

    @NotNull
    public final Sampling randomGroup(int sampleSize, @Nullable Long seed) {
        return new GroupRandomSampling(sampleSize, seed);
    }

    @NotNull
    public final Sampling systematicGroup(int sampleSize) {
        return new GroupSystematicSampling(sampleSize);
    }

    @NotNull
    public final Sampling randomStratified(int sampleSize, @Nullable Long seed, @Nullable Integer minSubSample) {
        return new RandomStratifiedSampling(sampleSize, seed, minSubSample);
    }

    private Samplings() {
    }

    static {
        Samplings samplings;
        INSTANCE = samplings = new Samplings();
        NONE = new NoneSampling();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/sampling/Samplings$NoneSampling;", "Ljetbrains/datalore/plot/builder/sampling/PointSampling;", "()V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "isApplicable", "", "plot-builder-portable"})
    private static final class NoneSampling
    implements PointSampling {
        @Override
        @NotNull
        public String getExpressionText() {
            return "none";
        }

        @Override
        public boolean isApplicable(@NotNull DataFrame population) {
            Intrinsics.checkNotNullParameter((Object)population, (String)"population");
            return false;
        }

        @Override
        @NotNull
        public DataFrame apply(@NotNull DataFrame population) {
            Intrinsics.checkNotNullParameter((Object)population, (String)"population");
            return population;
        }
    }
}

