/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalTiltedLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "labelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getLabelHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "labelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getLabelVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "axisMapper", "Lkotlin/Function1;", "maxLabelsBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBounds", "labelNormalSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "Companion", "plot-builder-portable"})
public final class HorizontalTiltedLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    private static final double MIN_DISTANCE = 5.0;
    private static final double ROTATION_DEGREE = -30.0;
    private static final double SIN;
    private static final double COS;
    public static final Companion Companion;

    private final TextLabel.HorizontalAnchor getLabelHorizontalAnchor() {
        if (this.getOrientation() == Orientation.BOTTOM) {
            return TextLabel.HorizontalAnchor.RIGHT;
        }
        throw (Throwable)new RuntimeException("Not implemented");
    }

    private final TextLabel.VerticalAnchor getLabelVerticalAnchor() {
        return TextLabel.VerticalAnchor.TOP;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper, @Nullable DoubleRectangle maxLabelsBounds) {
        DoubleRectangle bounds;
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        double height = this.getLabelSpec().height();
        List<Double> ticks = this.mapToAxis$plot_builder_portable(this.getBreaks().getTransformedValues(), axisMapper);
        boolean overlap = false;
        if (this.getBreaks().size() >= 2) {
            double d = (height + 5.0) / SIN;
            boolean bl = false;
            double minTickDistance = Math.abs(d);
            double d2 = ((Number)ticks.get(0)).doubleValue() - ((Number)ticks.get(1)).doubleValue();
            boolean bl2 = false;
            double tickDistance = Math.abs(d2);
            overlap = tickDistance < minTickDistance;
        }
        DoubleRectangle doubleRectangle = bounds = this.labelsBounds(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return this.createAxisLabelsLayoutInfoBuilder(doubleRectangle, overlap).labelHorizontalAnchor(this.getLabelHorizontalAnchor()).labelVerticalAnchor(this.getLabelVerticalAnchor()).labelRotationAngle(-30.0).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        if (!(-30.0 >= (double)-90) || !(-30.0 <= 0.0) || this.getLabelHorizontalAnchor() != TextLabel.HorizontalAnchor.RIGHT || this.getLabelVerticalAnchor() != TextLabel.VerticalAnchor.TOP) {
            throw (Throwable)new RuntimeException("Not implemented");
        }
        double d = labelNormalSize.getX() * COS;
        boolean bl = false;
        double d2 = Math.abs(d);
        d = labelNormalSize.getY() * SIN;
        bl = false;
        double w = d2 + (double)2 * Math.abs(d);
        double d3 = labelNormalSize.getX() * SIN;
        boolean bl2 = false;
        double d4 = Math.abs(d3);
        d3 = labelNormalSize.getY() * COS;
        bl2 = false;
        double h = d4 + Math.abs(d3);
        double d5 = labelNormalSize.getX() * COS;
        boolean bl3 = false;
        double d6 = Math.abs(d5);
        d5 = labelNormalSize.getY() * SIN;
        bl3 = false;
        double x2 = -(d6 + Math.abs(d5));
        double y2 = 0.0;
        return new DoubleRectangle(x2, y2, w, h);
    }

    public HorizontalTiltedLabelsLayout(@NotNull Orientation orientation, @NotNull ClosedRange<Double> axisDomain, @NotNull PlotLabelSpec labelSpec, @NotNull GuideBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, labelSpec, breaks, theme);
    }

    static {
        Companion = new Companion(null);
        double d = MathKt.toRadians(-30.0);
        boolean bl = false;
        SIN = Math.sin(d);
        d = MathKt.toRadians(-30.0);
        bl = false;
        COS = Math.cos(d);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalTiltedLabelsLayout$Companion;", "", "()V", "COS", "", "MIN_DISTANCE", "ROTATION_DEGREE", "SIN", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

