/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.BreakLabelsLayoutUtil$WhenMappings;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJD\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ@\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0011J\u0014\u0010\u001f\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eJ6\u0010\"\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0011H\u0002\u00a8\u0006#"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/BreakLabelsLayoutUtil;", "", "()V", "applyLabelsOffset", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelsBounds", "offset", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "doLayoutVerticalAxisLabels", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "axisMapper", "Lkotlin/Function1;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "getFlexBreaks", "breaksProvider", "Ljetbrains/datalore/plot/builder/layout/axis/AxisBreaksProvider;", "maxCount", "", "axisLength", "horizontalCenteredLabelBounds", "labelSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "mapToAxis", "", "maxLength", "labels", "", "verticalAxisLabelsBounds", "plot-builder-portable"})
public final class BreakLabelsLayoutUtil {
    public static final BreakLabelsLayoutUtil INSTANCE;

    @NotNull
    public final GuideBreaks getFlexBreaks(@NotNull AxisBreaksProvider breaksProvider, int maxCount, double axisLength) {
        Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
        Preconditions.INSTANCE.checkArgument(!breaksProvider.isFixedBreaks(), "fixed breaks not expected");
        Preconditions.INSTANCE.checkArgument(maxCount > 0, "maxCount=" + maxCount);
        GuideBreaks breaks = breaksProvider.getBreaks(maxCount, axisLength);
        if (maxCount == 1 && !breaks.isEmpty()) {
            return new GuideBreaks(breaks.getDomainValues().subList(0, 1), breaks.getTransformedValues().subList(0, 1), breaks.getLabels().subList(0, 1));
        }
        int count2 = maxCount;
        while (breaks.size() > maxCount) {
            int n = 1;
            int n2 = (breaks.size() - maxCount) / 2;
            boolean bl = false;
            int delta = Math.max(n, n2);
            breaks = breaksProvider.getBreaks(count2 -= delta, axisLength);
        }
        return breaks;
    }

    public final int maxLength(@NotNull List<String> labels) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        int max = 0;
        for (String label : labels) {
            int n = label.length();
            boolean bl = false;
            max = Math.max(max, n);
        }
        return max;
    }

    @NotNull
    public final DoubleRectangle horizontalCenteredLabelBounds(@NotNull DoubleVector labelSize) {
        Intrinsics.checkNotNullParameter((Object)labelSize, (String)"labelSize");
        return new DoubleRectangle(-labelSize.getX() / 2.0, 0.0, labelSize.getX(), labelSize.getY());
    }

    @NotNull
    public final AxisLabelsLayoutInfo doLayoutVerticalAxisLabels(@NotNull Orientation orientation, @NotNull GuideBreaks breaks, @NotNull ClosedRange<Double> axisDomain, @NotNull Function1<? super Double, Double> axisMapper, @NotNull AxisTheme theme) {
        DoubleRectangle doubleRectangle;
        DoubleRectangle labelsBounds;
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (theme.showTickLabels()) {
            labelsBounds = this.verticalAxisLabelsBounds(breaks, axisDomain, axisMapper);
            doubleRectangle = this.applyLabelsOffset(labelsBounds, theme.tickLabelDistance(), orientation);
        } else if (theme.showTickMarks()) {
            labelsBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
            doubleRectangle = this.applyLabelsOffset(labelsBounds, theme.tickLabelDistance(), orientation);
        } else {
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        }
        DoubleRectangle axisBounds = doubleRectangle;
        return new AxisLabelsLayoutInfo.Builder().breaks(breaks).bounds(axisBounds).build();
    }

    @NotNull
    public final List<Double> mapToAxis(@NotNull List<Double> breaks, @NotNull ClosedRange<Double> axisDomain, @NotNull Function1<? super Double, Double> axisMapper) {
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        double axisMin = ((Number)axisDomain.getLowerEnd()).doubleValue();
        ArrayList<Double> axisBreaks = new ArrayList<Double>();
        Iterator<Double> iterator2 = breaks.iterator();
        while (iterator2.hasNext()) {
            Double mapped;
            double v = ((Number)iterator2.next()).doubleValue();
            Double d = mapped = (Double)axisMapper.invoke((Object)(v - axisMin));
            Intrinsics.checkNotNull((Object)d);
            axisBreaks.add(d);
        }
        return axisBreaks;
    }

    @NotNull
    public final DoubleRectangle applyLabelsOffset(@NotNull DoubleRectangle labelsBounds, double offset2, @NotNull Orientation orientation) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)labelsBounds, (String)"labelsBounds");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        DoubleRectangle labelsBounds2 = labelsBounds;
        switch (BreakLabelsLayoutUtil$WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(-offset2, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(offset2, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, -offset2);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, offset2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector offsetVector = doubleVector;
        if (orientation == Orientation.RIGHT || orientation == Orientation.BOTTOM) {
            labelsBounds2 = labelsBounds2.add(offsetVector);
        } else if (orientation == Orientation.LEFT || orientation == Orientation.TOP) {
            labelsBounds2 = labelsBounds2.add(offsetVector).subtract(new DoubleVector(labelsBounds2.getWidth(), 0.0));
        }
        return labelsBounds2;
    }

    private final DoubleRectangle verticalAxisLabelsBounds(GuideBreaks breaks, ClosedRange<Double> axisDomain, Function1<? super Double, Double> axisMapper) {
        int maxLength = this.maxLength(breaks.getLabels());
        double maxLabelWidth = AxisLabelsLayout.Companion.getTICK_LABEL_SPEC().width(maxLength);
        double y1 = 0.0;
        double y2 = 0.0;
        if (!breaks.isEmpty()) {
            List<Double> axisBreaks = this.mapToAxis(breaks.getTransformedValues(), axisDomain, axisMapper);
            double d = ((Number)axisBreaks.get(0)).doubleValue();
            double d2 = ((Number)Iterables.INSTANCE.getLast((Iterable)axisBreaks)).doubleValue();
            boolean bl = false;
            y1 = Math.min(d, d2);
            d = ((Number)axisBreaks.get(0)).doubleValue();
            d2 = ((Number)Iterables.INSTANCE.getLast((Iterable)axisBreaks)).doubleValue();
            bl = false;
            y2 = Math.max(d, d2);
            y1 -= AxisLabelsLayout.Companion.getTICK_LABEL_SPEC().height() / (double)2;
            y2 += AxisLabelsLayout.Companion.getTICK_LABEL_SPEC().height() / (double)2;
        }
        DoubleVector origin = new DoubleVector(0.0, y1);
        DoubleVector dimensions = new DoubleVector(maxLabelWidth, y2 - y1);
        return new DoubleRectangle(origin, dimensions);
    }

    private BreakLabelsLayoutUtil() {
    }

    static {
        BreakLabelsLayoutUtil breakLabelsLayoutUtil;
        INSTANCE = breakLabelsLayoutUtil = new BreakLabelsLayoutUtil();
    }
}

