/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutBase;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotLayoutUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout;", "Ljetbrains/datalore/plot/builder/layout/TileLayoutBase;", "myXAxisLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "myYAxisLayout", "(Ljetbrains/datalore/plot/builder/layout/AxisLayout;Ljetbrains/datalore/plot/builder/layout/AxisLayout;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "Companion", "plot-builder-portable"})
public final class XYPlotTileLayout
extends TileLayoutBase {
    private final AxisLayout myXAxisLayout;
    private final AxisLayout myYAxisLayout;
    private static final double AXIS_STRETCH_RATIO = 0.1;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public TileLayoutInfo doLayout(@NotNull DoubleVector preferredSize) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        double xAxisThickness = this.myXAxisLayout.initialThickness();
        double yAxisThickness = this.myYAxisLayout.initialThickness();
        DoubleRectangle geomBounds = TileLayoutBase.Companion.geomBounds(xAxisThickness, yAxisThickness, preferredSize);
        AxisLayoutInfo xAxisInfo = null;
        AxisLayoutInfo yAxisInfo = null;
        boolean doX = true;
        while (doX) {
            boolean doY = false;
            doX = false;
            XYPlotTileLayout xYPlotTileLayout = this;
            bl = false;
            boolean bl2 = false;
            XYPlotTileLayout $this$run = xYPlotTileLayout;
            boolean bl3 = false;
            double axisLength = geomBounds.getDimension().getX();
            double stretch = axisLength * 0.1;
            DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, stretch, geomBounds, preferredSize);
            AxisLayoutInfo axisLayoutInfo = xAxisInfo = $this$run.myXAxisLayout.doLayout(geomBounds.getDimension(), maxTickLabelsBounds);
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            double axisThicknessNew = axisLayoutInfo.axisBounds().getDimension().getY();
            if (axisThicknessNew > xAxisThickness) {
                doY = true;
                geomBounds = TileLayoutBase.Companion.geomBounds(axisThicknessNew, yAxisThickness, preferredSize);
            }
            xAxisThickness = axisThicknessNew;
            if (!doY && yAxisInfo != null) continue;
            yAxisInfo = this.myYAxisLayout.doLayout(geomBounds.getDimension(), null);
            double axisThicknessNew2 = yAxisInfo.axisBounds().getDimension().getX();
            if (axisThicknessNew2 > yAxisThickness) {
                doX = true;
                geomBounds = TileLayoutBase.Companion.geomBounds(xAxisThickness, axisThicknessNew2, preferredSize);
            }
            yAxisThickness = axisThicknessNew2;
        }
        XYPlotTileLayout doY = this;
        boolean bl4 = false;
        bl = false;
        XYPlotTileLayout $this$run = doY;
        boolean bl5 = false;
        DoubleRectangle maxTickLabelsBounds = XYPlotLayoutUtil.INSTANCE.maxTickLabelsBounds(Orientation.BOTTOM, 0.0, geomBounds, preferredSize);
        AxisLayoutInfo axisLayoutInfo = xAxisInfo;
        Intrinsics.checkNotNull((Object)axisLayoutInfo);
        DoubleRectangle tickLabelsBounds = axisLayoutInfo.getTickLabelsBounds();
        double d = maxTickLabelsBounds.getLeft();
        DoubleRectangle doubleRectangle = tickLabelsBounds;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        double leftOverflow = d - doubleRectangle.getOrigin().getX();
        double rightOverflow = tickLabelsBounds.getOrigin().getX() + tickLabelsBounds.getDimension().getX() - maxTickLabelsBounds.getRight();
        if (leftOverflow > 0.0) {
            geomBounds = new DoubleRectangle(geomBounds.getOrigin().getX() + leftOverflow, geomBounds.getOrigin().getY(), geomBounds.getDimension().getX() - leftOverflow, geomBounds.getDimension().getY());
        }
        if (rightOverflow > 0.0) {
            geomBounds = new DoubleRectangle(geomBounds.getOrigin().getX(), geomBounds.getOrigin().getY(), geomBounds.getDimension().getX() - rightOverflow, geomBounds.getDimension().getY());
        }
        geomBounds = geomBounds.union(new DoubleRectangle(geomBounds.getOrigin(), TileLayoutBase.Companion.getGEOM_MIN_SIZE()));
        AxisLayoutInfo axisLayoutInfo2 = xAxisInfo;
        Intrinsics.checkNotNull((Object)axisLayoutInfo2);
        DoubleRectangle doubleRectangle2 = axisLayoutInfo2.axisBounds();
        AxisLayoutInfo axisLayoutInfo3 = yAxisInfo;
        Intrinsics.checkNotNull((Object)axisLayoutInfo3);
        DoubleRectangle geomWithAxisBounds = XYPlotTileLayout.Companion.tileBounds(doubleRectangle2, axisLayoutInfo3.axisBounds(), geomBounds);
        AxisLayoutInfo axisLayoutInfo4 = xAxisInfo;
        Intrinsics.checkNotNull((Object)axisLayoutInfo4);
        xAxisInfo = axisLayoutInfo4.withAxisLength(geomBounds.getWidth()).build();
        yAxisInfo = yAxisInfo.withAxisLength(geomBounds.getHeight()).build();
        DoubleRectangle doubleRectangle3 = TileLayoutBase.Companion.clipBounds(geomBounds);
        AxisLayoutInfo axisLayoutInfo5 = xAxisInfo;
        Intrinsics.checkNotNull((Object)axisLayoutInfo5);
        return new TileLayoutInfo(geomWithAxisBounds, geomBounds, doubleRectangle3, axisLayoutInfo5, yAxisInfo);
    }

    public XYPlotTileLayout(@NotNull AxisLayout myXAxisLayout, @NotNull AxisLayout myYAxisLayout) {
        Intrinsics.checkNotNullParameter((Object)myXAxisLayout, (String)"myXAxisLayout");
        Intrinsics.checkNotNullParameter((Object)myYAxisLayout, (String)"myYAxisLayout");
        this.myXAxisLayout = myXAxisLayout;
        this.myYAxisLayout = myYAxisLayout;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/builder/layout/XYPlotTileLayout$Companion;", "", "()V", "AXIS_STRETCH_RATIO", "", "tileBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "xAxisBounds", "yAxisBounds", "geomBounds", "plot-builder-portable"})
    public static final class Companion {
        private final DoubleRectangle tileBounds(DoubleRectangle xAxisBounds, DoubleRectangle yAxisBounds, DoubleRectangle geomBounds) {
            DoubleVector leftTop = new DoubleVector(geomBounds.getLeft() - yAxisBounds.getWidth(), geomBounds.getTop() - 0.0);
            DoubleVector rightBottom = new DoubleVector(geomBounds.getRight() + 0.0, geomBounds.getBottom() + xAxisBounds.getHeight());
            return new DoubleRectangle(leftTop, rightBottom.subtract(leftTop));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

