/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendJustification;
import jetbrains.datalore.plot.builder.guide.LegendPosition;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J&\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayoutUtil;", "", "()V", "horizontalStack", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "boxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "moveAll", "delta", "Ljetbrains/datalore/base/geometry/DoubleVector;", "boxWithLocationList", "overlayLegendOrigin", "plotBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "legendSize", "legendPosition", "Ljetbrains/datalore/plot/builder/guide/LegendPosition;", "legendJustification", "Ljetbrains/datalore/plot/builder/guide/LegendJustification;", "size", "verticalStack", "plot-builder-portable"})
public final class LegendBoxesLayoutUtil {
    public static final LegendBoxesLayoutUtil INSTANCE;

    @NotNull
    public final List<LegendBoxesLayout.BoxWithLocation> verticalStack(@NotNull List<? extends LegendBoxInfo> boxInfos) {
        Intrinsics.checkNotNullParameter(boxInfos, (String)"boxInfos");
        ArrayList<LegendBoxesLayout.BoxWithLocation> result = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double y2 = 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            result.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(0.0, y2)));
            y2 += legendBoxInfo.getSize$plot_builder_portable().getY();
        }
        return result;
    }

    @NotNull
    public final List<LegendBoxesLayout.BoxWithLocation> horizontalStack(@NotNull List<? extends LegendBoxInfo> boxInfos) {
        Intrinsics.checkNotNullParameter(boxInfos, (String)"boxInfos");
        ArrayList<LegendBoxesLayout.BoxWithLocation> result = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double x2 = 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            result.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(x2, 0.0)));
            x2 += legendBoxInfo.getSize$plot_builder_portable().getX();
        }
        return result;
    }

    @NotNull
    public final List<LegendBoxesLayout.BoxWithLocation> moveAll(@NotNull DoubleVector delta, @NotNull List<LegendBoxesLayout.BoxWithLocation> boxWithLocationList) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Intrinsics.checkNotNullParameter(boxWithLocationList, (String)"boxWithLocationList");
        ArrayList<LegendBoxesLayout.BoxWithLocation> result = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        for (LegendBoxesLayout.BoxWithLocation boxWithLocation : boxWithLocationList) {
            result.add(new LegendBoxesLayout.BoxWithLocation(boxWithLocation.getLegendBox(), boxWithLocation.getLocation().add(delta)));
        }
        return result;
    }

    @NotNull
    public final DoubleVector size(@NotNull List<LegendBoxesLayout.BoxWithLocation> boxWithLocationList) {
        Intrinsics.checkNotNullParameter(boxWithLocationList, (String)"boxWithLocationList");
        DoubleRectangle bounds = null;
        for (LegendBoxesLayout.BoxWithLocation boxWithLocation : boxWithLocationList) {
            DoubleRectangle doubleRectangle = bounds;
            if (doubleRectangle == null || (doubleRectangle = doubleRectangle.union(boxWithLocation.bounds$plot_builder_portable())) == null) {
                doubleRectangle = boxWithLocation.bounds$plot_builder_portable();
            }
            bounds = doubleRectangle;
        }
        Object object = bounds;
        if (object == null || (object = ((DoubleRectangle)object).getDimension()) == null) {
            object = DoubleVector.Companion.getZERO();
        }
        return object;
    }

    @NotNull
    public final DoubleVector overlayLegendOrigin(@NotNull DoubleRectangle plotBounds, @NotNull DoubleVector legendSize, @NotNull LegendPosition legendPosition, @NotNull LegendJustification legendJustification) {
        Intrinsics.checkNotNullParameter((Object)plotBounds, (String)"plotBounds");
        Intrinsics.checkNotNullParameter((Object)legendSize, (String)"legendSize");
        Intrinsics.checkNotNullParameter((Object)legendPosition, (String)"legendPosition");
        Intrinsics.checkNotNullParameter((Object)legendJustification, (String)"legendJustification");
        DoubleVector plotSize = plotBounds.getDimension();
        DoubleVector absolutePosition = new DoubleVector(plotBounds.getLeft() + plotSize.getX() * legendPosition.getX(), plotBounds.getBottom() - plotSize.getY() * legendPosition.getY());
        DoubleVector originOffset = new DoubleVector(-legendSize.getX() * legendJustification.getX(), legendSize.getY() * legendJustification.getY() - legendSize.getY());
        return absolutePosition.add(originOffset);
    }

    private LegendBoxesLayoutUtil() {
    }

    static {
        LegendBoxesLayoutUtil legendBoxesLayoutUtil;
        INSTANCE = legendBoxesLayoutUtil = new LegendBoxesLayoutUtil();
    }
}

