/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact.loc;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.interact.ContextualMapping;
import jetbrains.datalore.plot.base.interact.GeomTarget;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.loc.LayerTargetLocator$Collector$WhenMappings;
import jetbrains.datalore.plot.builder.interact.loc.LayerTargetLocator$WhenMappings;
import jetbrains.datalore.plot.builder.interact.loc.PathTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PointTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.RectTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetDetector;
import jetbrains.datalore.plot.builder.interact.loc.TargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetPrototype;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\tH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J&\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010)\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J&\u0010*\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator;", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "geomKind", "Ljetbrains/datalore/plot/base/GeomKind;", "lookupSpec", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpec;", "contextualMapping", "Ljetbrains/datalore/plot/base/interact/ContextualMapping;", "targetPrototypes", "", "Ljetbrains/datalore/plot/builder/interact/loc/TargetPrototype;", "(Ljetbrains/datalore/plot/base/GeomKind;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpec;Ljetbrains/datalore/plot/base/interact/ContextualMapping;Ljava/util/List;)V", "myCollectingStrategy", "Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector$CollectingStrategy;", "mySimpleGeometry", "", "myTargetDetector", "Ljetbrains/datalore/plot/builder/interact/loc/TargetDetector;", "myTargets", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Target;", "Lkotlin/collections/ArrayList;", "addLookupResults", "", "collector", "Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector;", "Ljetbrains/datalore/plot/base/interact/GeomTarget;", "targets", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupResult;", "getClosestTarget", "lookupResults", "getKeyForSingleObjectGeometry", "", "prototype", "processPath", "coord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "target", "resultCollector", "processPoint", "processPolygon", "processRect", "search", "Collector", "Target", "plot-builder-portable"})
public final class LayerTargetLocator
implements GeomTargetLocator {
    private final ArrayList<Target> myTargets;
    private final TargetDetector myTargetDetector;
    private final Set<GeomKind> mySimpleGeometry;
    private final Collector.CollectingStrategy myCollectingStrategy;
    private final GeomKind geomKind;
    private final ContextualMapping contextualMapping;

    private final void addLookupResults(Collector<GeomTarget> collector2, List<GeomTargetLocator.LookupResult> targets) {
        if (collector2.size() == 0) {
            return;
        }
        double d = 0.0;
        double d2 = collector2.getClosestPointChecker().getDistance();
        boolean bl = false;
        targets.add(new GeomTargetLocator.LookupResult(collector2.collection(), Math.max(d, d2), this.geomKind, this.contextualMapping));
    }

    @Override
    @Nullable
    public GeomTargetLocator.LookupResult search(@NotNull DoubleVector coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (this.myTargets.isEmpty()) {
            return null;
        }
        Collector<GeomTarget> rectCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy);
        Collector<GeomTarget> pointCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy);
        Collector<GeomTarget> pathCollector = new Collector<GeomTarget>(coord, this.myCollectingStrategy);
        Collector<GeomTarget> polygonCollector = new Collector<GeomTarget>(coord, Collector.CollectingStrategy.REPLACE);
        for (Target target : this.myTargets) {
            switch (LayerTargetLocator$WhenMappings.$EnumSwitchMapping$1[target.getPrototype().getHitShape$plot_builder_portable().getKind().ordinal()]) {
                case 1: {
                    Target target2 = target;
                    Intrinsics.checkNotNullExpressionValue((Object)target2, (String)"target");
                    this.processRect(coord, target2, rectCollector);
                    break;
                }
                case 2: {
                    Target target3 = target;
                    Intrinsics.checkNotNullExpressionValue((Object)target3, (String)"target");
                    this.processPoint(coord, target3, pointCollector);
                    break;
                }
                case 3: {
                    Target target4 = target;
                    Intrinsics.checkNotNullExpressionValue((Object)target4, (String)"target");
                    this.processPath(coord, target4, pathCollector);
                    break;
                }
                case 4: {
                    Target target5 = target;
                    Intrinsics.checkNotNullExpressionValue((Object)target5, (String)"target");
                    this.processPolygon(coord, target5, polygonCollector);
                    break;
                }
            }
        }
        ArrayList lookupResults = new ArrayList();
        this.addLookupResults(pathCollector, lookupResults);
        this.addLookupResults(rectCollector, lookupResults);
        this.addLookupResults(pointCollector, lookupResults);
        this.addLookupResults(polygonCollector, lookupResults);
        return this.getClosestTarget(lookupResults);
    }

    private final GeomTargetLocator.LookupResult getClosestTarget(List<? extends GeomTargetLocator.LookupResult> lookupResults) {
        if (lookupResults.isEmpty()) {
            return null;
        }
        GeomTargetLocator.LookupResult closestTargets = lookupResults.get(0);
        Preconditions.INSTANCE.checkArgument(closestTargets.getDistance() >= 0.0);
        for (GeomTargetLocator.LookupResult lookupResult : lookupResults) {
            if (!(lookupResult.getDistance() < closestTargets.getDistance())) continue;
            closestTargets = lookupResult;
        }
        return closestTargets;
    }

    private final void processRect(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkRect(coord, target.getRectProjection(), resultCollector.getClosestPointChecker())) {
            DoubleRectangle rect2 = target.getPrototype().getHitShape$plot_builder_portable().getRect();
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder_portable(rect2.getOrigin().add(new DoubleVector(rect2.getWidth() / (double)2, 0.0)), this.getKeyForSingleObjectGeometry(target.getPrototype())));
        }
    }

    private final void processPolygon(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkPolygon(coord, target.getPolygonProjection(), resultCollector.getClosestPointChecker())) {
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder_portable(coord, this.getKeyForSingleObjectGeometry(target.getPrototype())));
        }
    }

    private final void processPoint(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        if (this.myTargetDetector.checkPoint(coord, target.getPointProjection(), resultCollector.getClosestPointChecker())) {
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder_portable(target.getPrototype().getHitShape$plot_builder_portable().getPoint().getCenter(), this.getKeyForSingleObjectGeometry(target.getPrototype())));
        }
    }

    private final void processPath(DoubleVector coord, Target target, Collector<GeomTarget> resultCollector) {
        MathUtil.ClosestPointChecker pointChecker = this.myCollectingStrategy == Collector.CollectingStrategy.APPEND ? new MathUtil.ClosestPointChecker(coord) : resultCollector.getClosestPointChecker();
        PathTargetProjection.PathPoint hitPoint = this.myTargetDetector.checkPath(coord, target.getPathProjection(), pointChecker);
        if (hitPoint != null) {
            resultCollector.collect(target.getPrototype().createGeomTarget$plot_builder_portable(hitPoint.getOriginalCoord(), hitPoint.getIndex()));
        }
    }

    private final int getKeyForSingleObjectGeometry(TargetPrototype prototype) {
        return ((Number)prototype.getIndexMapper$plot_builder_portable().invoke((Object)0)).intValue();
    }

    public LayerTargetLocator(@NotNull GeomKind geomKind, final @NotNull GeomTargetLocator.LookupSpec lookupSpec, @NotNull ContextualMapping contextualMapping, @NotNull List<TargetPrototype> targetPrototypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)geomKind), (String)"geomKind");
        Intrinsics.checkNotNullParameter((Object)lookupSpec, (String)"lookupSpec");
        Intrinsics.checkNotNullParameter((Object)contextualMapping, (String)"contextualMapping");
        Intrinsics.checkNotNullParameter(targetPrototypes, (String)"targetPrototypes");
        this.geomKind = geomKind;
        this.contextualMapping = contextualMapping;
        this.myTargets = new ArrayList();
        this.myTargetDetector = new TargetDetector(lookupSpec.getLookupSpace(), lookupSpec.getLookupStrategy());
        this.mySimpleGeometry = SetsKt.setOf((Object[])new GeomKind[]{GeomKind.RECT, GeomKind.POLYGON});
        this.myCollectingStrategy = this.mySimpleGeometry.contains((Object)this.geomKind) ? Collector.CollectingStrategy.REPLACE : (lookupSpec.getLookupSpace() == GeomTargetLocator.LookupSpace.X ? Collector.CollectingStrategy.APPEND : (lookupSpec.getLookupStrategy() == GeomTargetLocator.LookupStrategy.HOVER ? Collector.CollectingStrategy.APPEND : (lookupSpec.getLookupStrategy() == GeomTargetLocator.LookupStrategy.NONE || lookupSpec.getLookupSpace() == GeomTargetLocator.LookupSpace.NONE ? Collector.CollectingStrategy.IGNORE : Collector.CollectingStrategy.REPLACE)));
        Function1<TargetPrototype, TargetProjection> $fun$toProjection$1 = new Function1<TargetPrototype, TargetProjection>(){

            @NotNull
            public final TargetProjection invoke(@NotNull TargetPrototype prototype) {
                TargetProjection targetProjection;
                Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
                switch (LayerTargetLocator$WhenMappings.$EnumSwitchMapping$0[prototype.getHitShape$plot_builder_portable().getKind().ordinal()]) {
                    case 1: {
                        targetProjection = PointTargetProjection.Companion.create(prototype.getHitShape$plot_builder_portable().getPoint().getCenter(), lookupSpec.getLookupSpace());
                        break;
                    }
                    case 2: {
                        targetProjection = RectTargetProjection.Companion.create(prototype.getHitShape$plot_builder_portable().getRect(), lookupSpec.getLookupSpace());
                        break;
                    }
                    case 3: {
                        targetProjection = PolygonTargetProjection.Companion.create(prototype.getHitShape$plot_builder_portable().getPoints(), lookupSpec.getLookupSpace());
                        break;
                    }
                    case 4: {
                        targetProjection = PathTargetProjection.Companion.create(prototype.getHitShape$plot_builder_portable().getPoints(), prototype.getIndexMapper$plot_builder_portable(), lookupSpec.getLookupSpace());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return targetProjection;
            }
        };
        for (TargetPrototype prototype : targetPrototypes) {
            this.myTargets.add(new Target($fun$toProjection$1.invoke(prototype), prototype));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Target;", "", "targetProjection", "Ljetbrains/datalore/plot/builder/interact/loc/TargetProjection;", "prototype", "Ljetbrains/datalore/plot/builder/interact/loc/TargetPrototype;", "(Ljetbrains/datalore/plot/builder/interact/loc/TargetProjection;Ljetbrains/datalore/plot/builder/interact/loc/TargetPrototype;)V", "pathProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection;", "getPathProjection", "()Ljetbrains/datalore/plot/builder/interact/loc/PathTargetProjection;", "pointProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PointTargetProjection;", "getPointProjection", "()Ljetbrains/datalore/plot/builder/interact/loc/PointTargetProjection;", "polygonProjection", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "getPolygonProjection", "()Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "getPrototype", "()Ljetbrains/datalore/plot/builder/interact/loc/TargetPrototype;", "rectProjection", "Ljetbrains/datalore/plot/builder/interact/loc/RectTargetProjection;", "getRectProjection", "()Ljetbrains/datalore/plot/builder/interact/loc/RectTargetProjection;", "plot-builder-portable"})
    public static final class Target {
        private final TargetProjection targetProjection;
        @NotNull
        private final TargetPrototype prototype;

        @NotNull
        public final PointTargetProjection getPointProjection() {
            TargetProjection targetProjection = this.targetProjection;
            if (targetProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.interact.loc.PointTargetProjection");
            }
            return (PointTargetProjection)targetProjection;
        }

        @NotNull
        public final RectTargetProjection getRectProjection() {
            TargetProjection targetProjection = this.targetProjection;
            if (targetProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.interact.loc.RectTargetProjection");
            }
            return (RectTargetProjection)targetProjection;
        }

        @NotNull
        public final PolygonTargetProjection getPolygonProjection() {
            TargetProjection targetProjection = this.targetProjection;
            if (targetProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection");
            }
            return (PolygonTargetProjection)targetProjection;
        }

        @NotNull
        public final PathTargetProjection getPathProjection() {
            TargetProjection targetProjection = this.targetProjection;
            if (targetProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.interact.loc.PathTargetProjection");
            }
            return (PathTargetProjection)targetProjection;
        }

        @NotNull
        public final TargetPrototype getPrototype() {
            return this.prototype;
        }

        public Target(@NotNull TargetProjection targetProjection, @NotNull TargetPrototype prototype) {
            Intrinsics.checkNotNullParameter((Object)targetProjection, (String)"targetProjection");
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            this.targetProjection = targetProjection;
            this.prototype = prototype;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00028\u00000\rj\b\u0012\u0004\u0012\u00028\u0000`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector;", "T", "", "cursor", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myStrategy", "Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector$CollectingStrategy;", "(Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector$CollectingStrategy;)V", "closestPointChecker", "Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker;", "getClosestPointChecker", "()Ljetbrains/datalore/plot/builder/interact/MathUtil$ClosestPointChecker;", "result", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "add", "", "data", "(Ljava/lang/Object;)V", "collect", "collection", "", "replace", "locationData", "size", "", "CollectingStrategy", "plot-builder-portable"})
    public static final class Collector<T> {
        private final ArrayList<T> result;
        @NotNull
        private final MathUtil.ClosestPointChecker closestPointChecker;
        private final CollectingStrategy myStrategy;

        @NotNull
        public final MathUtil.ClosestPointChecker getClosestPointChecker() {
            return this.closestPointChecker;
        }

        public final void collect(T data) {
            switch (LayerTargetLocator$Collector$WhenMappings.$EnumSwitchMapping$0[this.myStrategy.ordinal()]) {
                case 1: {
                    this.add(data);
                    break;
                }
                case 2: {
                    this.replace(data);
                    break;
                }
                case 3: {
                    return;
                }
            }
        }

        @NotNull
        public final List<T> collection() {
            return this.result;
        }

        public final int size() {
            return this.result.size();
        }

        private final void add(T data) {
            this.result.add(data);
        }

        private final void replace(T locationData) {
            this.result.clear();
            this.result.add(locationData);
        }

        public Collector(@NotNull DoubleVector cursor, @NotNull CollectingStrategy myStrategy) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)((Object)myStrategy), (String)"myStrategy");
            this.myStrategy = myStrategy;
            this.result = new ArrayList();
            this.closestPointChecker = new MathUtil.ClosestPointChecker(cursor);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/LayerTargetLocator$Collector$CollectingStrategy;", "", "(Ljava/lang/String;I)V", "APPEND", "REPLACE", "IGNORE", "plot-builder-portable"})
        public static final class CollectingStrategy
        extends Enum<CollectingStrategy> {
            public static final /* enum */ CollectingStrategy APPEND;
            public static final /* enum */ CollectingStrategy REPLACE;
            public static final /* enum */ CollectingStrategy IGNORE;
            private static final /* synthetic */ CollectingStrategy[] $VALUES;

            static {
                CollectingStrategy[] collectingStrategyArray = new CollectingStrategy[3];
                CollectingStrategy[] collectingStrategyArray2 = collectingStrategyArray;
                collectingStrategyArray[0] = APPEND = new CollectingStrategy();
                collectingStrategyArray[1] = REPLACE = new CollectingStrategy();
                collectingStrategyArray[2] = IGNORE = new CollectingStrategy();
                $VALUES = collectingStrategyArray;
            }

            public static CollectingStrategy[] values() {
                return (CollectingStrategy[])$VALUES.clone();
            }

            public static CollectingStrategy valueOf(String string) {
                return Enum.valueOf(CollectingStrategy.class, string);
            }
        }
    }
}

