/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.Iterator;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.GroupComponent;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBoxSpec;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendComponentLayout;
import jetbrains.datalore.plot.builder.guide.LegendComponentSpec;
import jetbrains.datalore.vis.svg.SvgColors;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.SvgTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponent;", "Ljetbrains/datalore/plot/builder/guide/LegendBox;", "legendSpec", "Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "(Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;)V", "spec", "getSpec", "()Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "appendGuideContent", "Ljetbrains/datalore/base/geometry/DoubleVector;", "contentRoot", "Ljetbrains/datalore/vis/svg/SvgNode;", "createBreakElement", "Ljetbrains/datalore/vis/svg/SvgElement;", "br", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "keyLabelBox", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBox", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "legendBreak", "size", "plot-builder-portable"})
public final class LegendComponent
extends LegendBox {
    @Override
    @NotNull
    protected LegendComponentSpec getSpec() {
        LegendBoxSpec legendBoxSpec = super.getSpec();
        if (legendBoxSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.guide.LegendComponentSpec");
        }
        return (LegendComponentSpec)legendBoxSpec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        LegendComponentLayout l = this.getSpec().getLayout$plot_builder_portable();
        Iterator<DoubleRectangle> keyLabelBoxes = l.getKeyLabelBoxes().iterator();
        Iterator<DoubleRectangle> labelBoxes = l.getLabelBoxes().iterator();
        for (LegendBreak br : this.getSpec().getBreaks$plot_builder_portable()) {
            DoubleRectangle keyLabelBox = keyLabelBoxes.next();
            DoubleRectangle labelBox = labelBoxes.next();
            SvgElement breakElement = this.createBreakElement(br, l.getKeySize(), keyLabelBox, labelBox);
            contentRoot.children().add(breakElement);
        }
        return l.getSize();
    }

    private final SvgElement createBreakElement(LegendBreak br, DoubleVector keySize, DoubleRectangle keyLabelBox, DoubleRectangle labelBox) {
        GroupComponent breakComponent = new GroupComponent();
        breakComponent.add(this.createKeyElement(br, keySize));
        TextLabel label = new TextLabel(br.getLabel());
        label.setHorizontalAnchor(TextLabel.HorizontalAnchor.LEFT);
        label.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
        label.moveTo(labelBox.getOrigin().add(new DoubleVector(0.0, labelBox.getHeight() / (double)2)));
        breakComponent.add(label);
        breakComponent.moveTo(keyLabelBox.getOrigin());
        return breakComponent.getRootGroup();
    }

    private final SvgGElement createKeyElement(LegendBreak legendBreak, DoubleVector size2) {
        SvgGElement g = new SvgGElement();
        DoubleVector innerSize = new DoubleVector(size2.getX() - (double)2, size2.getY() - (double)2);
        Color backgroundFill = this.getSpec().getTheme().backgroundFill();
        SvgRectElement backgroundRect = new SvgRectElement(1.0, 1.0, innerSize.getX(), innerSize.getY());
        backgroundRect.strokeWidth().set(1.0);
        backgroundRect.strokeColor().set(backgroundFill);
        backgroundRect.fillColor().set(backgroundFill);
        g.children().add(backgroundRect);
        SvgGElement keyElement = legendBreak.createKeyElement(innerSize);
        SvgTransform keyElementTransform = SvgComponent.Companion.buildTransform(new DoubleVector(1.0, 1.0), 0.0);
        keyElement.transform().set(keyElementTransform);
        g.children().add(keyElement);
        SvgRectElement frame = new SvgRectElement(0.0, 0.0, size2.getX(), size2.getY());
        frame.strokeWidth().set(1.0);
        frame.strokeColor().set(backgroundFill);
        frame.fill().set(SvgColors.NONE);
        g.children().add(frame);
        return g;
    }

    public LegendComponent(@NotNull LegendComponentSpec legendSpec) {
        Intrinsics.checkNotNullParameter((Object)legendSpec, (String)"legendSpec");
        super(legendSpec);
    }
}

