/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.guide.LegendBoxLayout;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.scale.GuideBreak;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 /2\u00020\u0001:\u0004./01B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0006H \u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020,H\u0002R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0012\u0010 \u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001dR\u000e\u0010#\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u00170%j\b\u0012\u0004\u0012\u00020\u0017`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "title", "", "myDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "", "Ljetbrains/datalore/plot/builder/scale/GuideBreak;", "guideBarSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/guide/LegendDirection;)V", "barBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getBarBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barLengthExpand", "getBarLengthExpand", "()D", "breakInfos", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "getBreakInfos$plot_builder_portable", "()Ljava/util/List;", "getBreaks", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "graphSizeIntern", "getGraphSizeIntern", "guideBarLength", "getGuideBarLength", "getGuideBarSize", "myBarBounds", "myBreakInfos", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myContentSize", "createBreakInfo", "tickLocation", "createBreakInfo$plot_builder_portable", "doLayout", "", "ensureInited", "BreakInfo", "Companion", "MyHorizontal", "MyVertical", "plot-builder-portable"})
public abstract class ColorBarComponentLayout
extends LegendBoxLayout {
    private DoubleVector myContentSize;
    private final ArrayList<BreakInfo> myBreakInfos;
    private DoubleRectangle myBarBounds;
    private final ClosedRange<Double> myDomain;
    @NotNull
    private final List<GuideBreak<Double>> breaks;
    @NotNull
    private final DoubleVector guideBarSize;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DoubleVector getGraphSize() {
        this.ensureInited();
        DoubleVector doubleVector = this.myContentSize;
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector;
    }

    @NotNull
    public final List<BreakInfo> getBreakInfos$plot_builder_portable() {
        this.ensureInited();
        return this.myBreakInfos;
    }

    @NotNull
    public final DoubleRectangle getBarBounds() {
        this.ensureInited();
        DoubleRectangle doubleRectangle = this.myBarBounds;
        if (doubleRectangle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myBarBounds");
        }
        return doubleRectangle;
    }

    @NotNull
    protected abstract DoubleVector getGraphSizeIntern();

    protected abstract double getGuideBarLength();

    public final double getBarLengthExpand() {
        return 2.0;
    }

    private final void ensureInited() {
        if (this.myContentSize == null) {
            this.doLayout();
        }
    }

    private final void doLayout() {
        double guideBarLength = this.getGuideBarLength();
        ClosedRange<Comparable> targetRange = new ClosedRange<Comparable>(Double.valueOf(0.0 + this.getBarLengthExpand()), Double.valueOf(guideBarLength - this.getBarLengthExpand()));
        Function1<Double, Double> mapper2 = Mappers.INSTANCE.linear(this.myDomain, targetRange);
        for (GuideBreak<Double> br : this.breaks) {
            double tickLocation = ((Number)mapper2.invoke((Object)br.getDomainValue())).doubleValue();
            this.myBreakInfos.add(this.createBreakInfo$plot_builder_portable(tickLocation));
        }
        this.myContentSize = this.getGraphSizeIntern();
        this.myBarBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.guideBarSize);
    }

    @NotNull
    public abstract BreakInfo createBreakInfo$plot_builder_portable(double var1);

    @NotNull
    protected final List<GuideBreak<Double>> getBreaks() {
        return this.breaks;
    }

    @NotNull
    protected final DoubleVector getGuideBarSize() {
        return this.guideBarSize;
    }

    public ColorBarComponentLayout(@NotNull String title, @NotNull ClosedRange<Double> myDomain, @NotNull List<GuideBreak<Double>> breaks, @NotNull DoubleVector guideBarSize, @NotNull LegendDirection legendDirection) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(myDomain, (String)"myDomain");
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)guideBarSize, (String)"guideBarSize");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        super(title, legendDirection);
        this.myDomain = myDomain;
        this.breaks = breaks;
        this.guideBarSize = guideBarSize;
        this.myBreakInfos = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "", "tickLocation", "", "labelLocation", "Ljetbrains/datalore/base/geometry/DoubleVector;", "labelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "labelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "(DLjetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;)V", "getLabelHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getLabelLocation", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getLabelVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "getTickLocation", "()D", "plot-builder-portable"})
    public static final class BreakInfo {
        private final double tickLocation;
        @NotNull
        private final DoubleVector labelLocation;
        @NotNull
        private final TextLabel.HorizontalAnchor labelHorizontalAnchor;
        @NotNull
        private final TextLabel.VerticalAnchor labelVerticalAnchor;

        public final double getTickLocation() {
            return this.tickLocation;
        }

        @NotNull
        public final DoubleVector getLabelLocation() {
            return this.labelLocation;
        }

        @NotNull
        public final TextLabel.HorizontalAnchor getLabelHorizontalAnchor() {
            return this.labelHorizontalAnchor;
        }

        @NotNull
        public final TextLabel.VerticalAnchor getLabelVerticalAnchor() {
            return this.labelVerticalAnchor;
        }

        public BreakInfo(double tickLocation, @NotNull DoubleVector labelLocation, @NotNull TextLabel.HorizontalAnchor labelHorizontalAnchor, @NotNull TextLabel.VerticalAnchor labelVerticalAnchor) {
            Intrinsics.checkNotNullParameter((Object)labelLocation, (String)"labelLocation");
            Intrinsics.checkNotNullParameter((Object)((Object)labelHorizontalAnchor), (String)"labelHorizontalAnchor");
            Intrinsics.checkNotNullParameter((Object)((Object)labelVerticalAnchor), (String)"labelVerticalAnchor");
            this.tickLocation = tickLocation;
            this.labelLocation = labelLocation;
            this.labelHorizontalAnchor = labelHorizontalAnchor;
            this.labelVerticalAnchor = labelVerticalAnchor;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0018R\u0014\u0010\r\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$MyHorizontal;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "", "Ljetbrains/datalore/plot/builder/scale/GuideBreak;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "graphSizeIntern", "getGraphSizeIntern", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class MyHorizontal
    extends ColorBarComponentLayout {
        private final double getLabelDistance() {
            return LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height() / (double)3;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getX();
        }

        @Override
        @NotNull
        protected DoubleVector getGraphSizeIntern() {
            return new DoubleVector(this.getGuideBarSize().getX(), this.getGuideBarSize().getY() + this.getLabelDistance() + LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height());
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(tickLocation, this.getGuideBarSize().getY() + this.getLabelDistance());
            return new BreakInfo(tickLocation, labelLocation, TextLabel.HorizontalAnchor.MIDDLE, TextLabel.VerticalAnchor.TOP);
        }

        public MyHorizontal(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull List<GuideBreak<Double>> breaks, @NotNull DoubleVector barSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            super(title, domain, breaks, barSize, LegendDirection.HORIZONTAL);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0019R\u0014\u0010\r\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$MyVertical;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "", "Ljetbrains/datalore/plot/builder/scale/GuideBreak;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/lang/String;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "graphSizeIntern", "getGraphSizeIntern", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "myMaxLabelWidth", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class MyVertical
    extends ColorBarComponentLayout {
        private double myMaxLabelWidth;

        private final double getLabelDistance() {
            return LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(1) / (double)2;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getY();
        }

        @Override
        @NotNull
        protected DoubleVector getGraphSizeIntern() {
            return new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance() + this.myMaxLabelWidth, this.getGuideBarSize().getY());
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance(), tickLocation);
            return new BreakInfo(tickLocation, labelLocation, TextLabel.HorizontalAnchor.LEFT, TextLabel.VerticalAnchor.CENTER);
        }

        public MyVertical(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull List<GuideBreak<Double>> breaks, @NotNull DoubleVector barSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            super(title, domain, breaks, barSize, LegendDirection.VERTICAL);
            for (GuideBreak<Double> br : breaks) {
                double d = this.myMaxLabelWidth;
                double d2 = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(br.getLabel().length());
                boolean bl = false;
                this.myMaxLabelWidth = Math.max(d, d2);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$Companion;", "", "()V", "horizontal", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breaks", "", "Ljetbrains/datalore/plot/builder/scale/GuideBreak;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "vertical", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final ColorBarComponentLayout horizontal(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull List<GuideBreak<Double>> breaks, @NotNull DoubleVector barSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            return new MyHorizontal(title, domain, breaks, barSize);
        }

        @NotNull
        public final ColorBarComponentLayout vertical(@NotNull String title, @NotNull ClosedRange<Double> domain, @NotNull List<GuideBreak<Double>> breaks, @NotNull DoubleVector barSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(domain, (String)"domain");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            return new MyVertical(title, domain, breaks, barSize);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

