/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentLayout;
import jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBoxSpec;
import jetbrains.datalore.plot.builder.scale.GuideBreak;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0014\u0010\u0002\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponent;", "Ljetbrains/datalore/plot/builder/guide/LegendBox;", "spec", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "(Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;)V", "getSpec", "()Ljetbrains/datalore/plot/builder/guide/ColorBarComponentSpec;", "addColorBar", "", "g", "Ljetbrains/datalore/vis/svg/SvgGElement;", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "Ljetbrains/datalore/base/values/Color;", "numBins", "", "barBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barLengthExpand", "horizontal", "", "addTickMark", "p0", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p1", "appendGuideContent", "contentRoot", "Ljetbrains/datalore/vis/svg/SvgNode;", "plot-builder-portable"})
public final class ColorBarComponent
extends LegendBox {
    @Override
    @NotNull
    protected ColorBarComponentSpec getSpec() {
        LegendBoxSpec legendBoxSpec = super.getSpec();
        if (legendBoxSpec == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.guide.ColorBarComponentSpec");
        }
        return (ColorBarComponentSpec)legendBoxSpec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        ColorBarComponentSpec spec = this.getSpec();
        ColorBarComponentLayout l = spec.getLayout$plot_builder_portable();
        SvgGElement guideBarGroup = new SvgGElement();
        DoubleRectangle barBounds = l.getBarBounds();
        this.addColorBar(guideBarGroup, spec.getDomain$plot_builder_portable(), spec.getScale$plot_builder_portable(), spec.getBinCount$plot_builder_portable(), barBounds, l.getBarLengthExpand(), l.isHorizontal());
        double barThickness = l.isHorizontal() ? barBounds.getHeight() : barBounds.getWidth();
        double tickLength = barThickness / (double)5;
        Iterator<ColorBarComponentLayout.BreakInfo> breakInfos = l.getBreakInfos$plot_builder_portable().iterator();
        for (GuideBreak<Double> br : spec.getBreaks$plot_builder_portable()) {
            ColorBarComponentLayout.BreakInfo brInfo = breakInfos.next();
            double tickLocation = brInfo.getTickLocation();
            ArrayList<DoubleVector> tickMarkPoints = new ArrayList<DoubleVector>();
            if (l.isHorizontal()) {
                double tickX = tickLocation + barBounds.getLeft();
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop()));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop() + tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom() - tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom()));
            } else {
                double tickY = tickLocation + barBounds.getTop();
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft(), tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft() + tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight() - tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight(), tickY));
            }
            Object e = tickMarkPoints.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"tickMarkPoints[0]");
            DoubleVector doubleVector = (DoubleVector)e;
            Object e2 = tickMarkPoints.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"tickMarkPoints[1]");
            this.addTickMark(guideBarGroup, doubleVector, (DoubleVector)e2);
            Object e3 = tickMarkPoints.get(2);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"tickMarkPoints[2]");
            DoubleVector doubleVector2 = (DoubleVector)e3;
            Object e4 = tickMarkPoints.get(3);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"tickMarkPoints[3]");
            this.addTickMark(guideBarGroup, doubleVector2, (DoubleVector)e4);
            TextLabel label = new TextLabel(br.getLabel());
            label.setHorizontalAnchor(brInfo.getLabelHorizontalAnchor());
            label.setVerticalAnchor(brInfo.getLabelVerticalAnchor());
            label.moveTo(brInfo.getLabelLocation().getX(), brInfo.getLabelLocation().getY() + barBounds.getTop());
            guideBarGroup.children().add(label.getRootGroup());
        }
        guideBarGroup.children().add(LegendBox.Companion.createBorder(barBounds, spec.getTheme().backgroundFill(), 1.0));
        if (this.getDebug()) {
            DoubleRectangle graphBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), l.getGraphSize());
            guideBarGroup.children().add(LegendBox.Companion.createBorder(graphBounds, Color.Companion.getDARK_BLUE(), 1.0));
        }
        contentRoot.children().add(guideBarGroup);
        return l.getSize();
    }

    /*
     * WARNING - void declaration
     */
    private final void addColorBar(SvgGElement g, ClosedRange<Double> domain, Scale<Color> scale, int numBins, DoubleRectangle barBounds, double barLengthExpand, boolean horizontal) {
        double domainSpan = SeriesUtil.INSTANCE.span(domain);
        int n = 2;
        boolean bl = false;
        int stepCount = Math.max(n, numBins);
        double step = domainSpan / (double)stepCount;
        double v = ((Number)domain.getLowerEnd()).doubleValue() + step / (double)2;
        ArrayList<Double> domainValues = new ArrayList<Double>();
        int n2 = 0;
        int n3 = stepCount;
        while (n2 < n3) {
            void i;
            domainValues.add(v + step * (double)i);
            ++i;
        }
        List<Color> colors = ScaleUtil.INSTANCE.map((List<Double>)domainValues, scale);
        double barLength = horizontal ? barBounds.getWidth() : barBounds.getHeight();
        double effectiveBarLength = barLength - barLengthExpand * (double)2;
        double segmentStep = effectiveBarLength / (double)stepCount;
        double segmentLeft = barBounds.getLeft();
        double segmentRight = barBounds.getRight();
        double segmentBottom = barBounds.getBottom();
        double segmentTop = barBounds.getTop();
        boolean isFirst = true;
        for (Color color : colors) {
            SvgRectElement r = new SvgRectElement(segmentLeft, segmentTop, segmentRight - segmentLeft, segmentBottom - segmentTop);
            r.strokeWidth().set(0.0);
            r.fillColor().set(color);
            g.children().add(r);
            if (horizontal) {
                segmentLeft += segmentStep;
            } else {
                segmentTop += segmentStep;
            }
            if (!isFirst) continue;
            if (horizontal) {
                segmentLeft += barLengthExpand;
            } else {
                segmentTop += barLengthExpand;
            }
            isFirst = false;
        }
    }

    private final void addTickMark(SvgGElement g, DoubleVector p0, DoubleVector p1) {
        SvgLineElement line2 = new SvgLineElement(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        line2.strokeWidth().set(1.0);
        line2.strokeColor().set(this.getSpec().getTheme().backgroundFill());
        g.children().add(line2);
    }

    public ColorBarComponent(@NotNull ColorBarComponentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        super(spec);
    }
}

